/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager;

import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;

public abstract class DescriptionOfAlgorithm {
    public abstract String getImplementationAuthorNames();

    public abstract String getName();

    public abstract String getAlgorithmCategory();

    public abstract String getURLOfDocumentation();

    public abstract void runAlgorithm(String[] var1, String var2, String var3) throws Exception;

    public abstract DescriptionOfParameter[] getParametersDescription();

    public abstract String[] getInputFileTypes();

    public abstract String[] getOutputFileTypes();

    protected static double getParamAsDouble(String value) {
        if (value.contains("%")) {
            value = value.substring(0, value.length() - 1);
            return Double.parseDouble(value) / 100.0;
        }
        return Double.parseDouble(value);
    }

    protected static float getParamAsFloat(String value) {
        if (value.contains("%")) {
            value = value.substring(0, value.length() - 1);
            return Float.parseFloat(value) / 100.0f;
        }
        return Float.parseFloat(value);
    }

    protected static int getParamAsInteger(String value) {
        return Integer.parseInt(value);
    }

    protected static boolean getParamAsBoolean(String value) {
        if ("true".equals(value) || "True".equals(value) || "1".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "False".equals(value) || "0".equals(value)) {
            return false;
        }
        throw new NumberFormatException("Illegal value");
    }

    protected static String getParamAsString(String value) {
        return value;
    }

    public boolean isParameterOfCorrectType(String value, int i) {
        Class expectedClass = this.getParametersDescription()[i].parameterType;
        try {
            if (expectedClass == Double.class) {
                Double d = DescriptionOfAlgorithm.getParamAsDouble(value);
            } else if (expectedClass == Integer.class) {
                Integer n = DescriptionOfAlgorithm.getParamAsInteger(value);
            } else if (expectedClass == Boolean.class) {
                Boolean bl = DescriptionOfAlgorithm.getParamAsBoolean(value);
            } else if (expectedClass == String.class) {
                String string = DescriptionOfAlgorithm.getParamAsString(value);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

