/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.aprioriTID_inverse.AlgoAprioriTIDInverse;
import java.io.IOException;

public class DescriptionAlgoAprioriInverseTID
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "AprioriInverse_TID";
    }

    @Override
    public String getAlgorithmCategory() {
        return "FREQUENT ITEMSET MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/AprioriInverse.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoAprioriInverseTID.getParamAsDouble(parameters[0]);
        double maxsup = DescriptionAlgoAprioriInverseTID.getParamAsDouble(parameters[1]);
        AlgoAprioriTIDInverse algo = new AlgoAprioriTIDInverse();
        if (parameters.length >= 2 && !"".equals(parameters[2])) {
            algo.setShowTransactionIdentifiers(DescriptionAlgoAprioriInverseTID.getParamAsBoolean(parameters[2]));
        }
        algo.runAlgorithm(inputFile, outputFile, minsup, maxsup);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.1 or 10%)", Double.class, false), new DescriptionOfParameter("Maxsup (%)", "(e.g. 0.6 or 60%)", Double.class, false), new DescriptionOfParameter("Show transaction ids?", "(default: false)", Boolean.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Rare patterns", "Rare itemsets", "Perfectly rare itemsets"};
    }
}

