/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.aprioriTID_rare.AlgoAprioriTIDrare;
import java.io.IOException;

public class DescriptionAlgoAprioriRareTID
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "AprioriRare_TID";
    }

    @Override
    public String getAlgorithmCategory() {
        return "FREQUENT ITEMSET MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/AprioriRare.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoAprioriRareTID.getParamAsDouble(parameters[0]);
        AlgoAprioriTIDrare algo = new AlgoAprioriTIDrare();
        if (parameters.length >= 2 && !"".equals(parameters[1])) {
            algo.setShowTransactionIdentifiers(DescriptionAlgoAprioriRareTID.getParamAsBoolean(parameters[1]));
        }
        algo.runAlgorithm(inputFile, outputFile, minsup);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.6 or 60%)", Double.class, false), new DescriptionOfParameter("Show transaction ids?", "(default: false)", Boolean.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Rare patterns", "Rare itemsets", "Minimal rare itemsets"};
    }
}

