/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.aprioriTID.AlgoAprioriTID;
import java.io.IOException;

public class DescriptionAlgoAprioriTIDbitset
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "AprioriTID_Bitset";
    }

    @Override
    public String getAlgorithmCategory() {
        return "FREQUENT ITEMSET MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/AprioriTID.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoAprioriTIDbitset.getParamAsDouble(parameters[0]);
        AlgoAprioriTID algo = new AlgoAprioriTID();
        if (parameters.length >= 2 && !"".equals(parameters[1])) {
            algo.setShowTransactionIdentifiers(DescriptionAlgoAprioriTIDbitset.getParamAsBoolean(parameters[1]));
        }
        if (parameters.length >= 3 && !"".equals(parameters[2])) {
            algo.setMaximumPatternLength(DescriptionAlgoAprioriTIDbitset.getParamAsInteger(parameters[2]));
        }
        algo.runAlgorithm(inputFile, outputFile, minsup);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.4 or 40%)", Double.class, false), new DescriptionOfParameter("Show transaction ids?", "(default: false)", Boolean.class, true), new DescriptionOfParameter("Max pattern length", "(e.g. 2 items)", Integer.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Frequent patterns", "Frequent itemsets"};
    }
}

