/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.clustering.distanceFunctions.DistanceFunction;
import ca.pfv.spmf.algorithms.clustering.kmeans.AlgoBisectingKMeans;
import java.io.IOException;

public class DescriptionAlgoBisectingKMeans
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "BisectingKMeans";
    }

    @Override
    public String getAlgorithmCategory() {
        return "CLUSTERING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/BisectingKMeans.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int k = DescriptionAlgoBisectingKMeans.getParamAsInteger(parameters[0]);
        String distanceFunctionName = DescriptionAlgoBisectingKMeans.getParamAsString(parameters[1]);
        int iter = DescriptionAlgoBisectingKMeans.getParamAsInteger(parameters[2]);
        DistanceFunction distanceFunction = DistanceFunction.getDistanceFunctionByName(distanceFunctionName);
        String separator = parameters.length > 3 && !"".equals(parameters[3]) ? DescriptionAlgoBisectingKMeans.getParamAsString(parameters[3]) : " ";
        AlgoBisectingKMeans algo = new AlgoBisectingKMeans();
        algo.runAlgorithm(inputFile, k, distanceFunction, iter, separator);
        algo.printStatistics();
        algo.saveToFile(outputFile);
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("k", "(e.g. 3)", Integer.class, false), new DescriptionOfParameter("Distance function", "(e.g. euclidian, cosine...)", String.class, false), new DescriptionOfParameter("Iter", "(e.g. 10)", Integer.class, false), new DescriptionOfParameter("separator", "(default: ' ')", String.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Database of double vectors"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Clusters"};
    }
}

