/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.cost.AlgoCEPM;
import java.io.IOException;

public class DescriptionAlgoCEPB
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "CEPB";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/CEPBalgo.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minsup = DescriptionAlgoCEPB.getParamAsInteger(parameters[0]);
        double maxcost = DescriptionAlgoCEPB.getParamAsDouble(parameters[1]);
        double minOccupancy = DescriptionAlgoCEPB.getParamAsDouble(parameters[2]);
        int maxPatternLength = 999;
        if (parameters.length >= 4 && !"".equals(parameters[3])) {
            maxPatternLength = DescriptionAlgoCEPB.getParamAsInteger(parameters[3]);
        }
        AlgoCEPM algo = new AlgoCEPM();
        algo.setMaximumPatternLength(maxPatternLength);
        algo.runAlgorithmCEPB(inputFile, outputFile, minsup, maxcost, minOccupancy);
        algo.printStatistics();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup", "(e.g. 2)", Double.class, false), new DescriptionOfParameter("Maxcost", "(e.g. 50)", Integer.class, false), new DescriptionOfParameter("Minoccupancy", "(e.g. 0.1)", Double.class, false), new DescriptionOfParameter("Max pattern length", "", Integer.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Jiaxuan Li";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Sequence Database with cost and binary utility"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential patterns", "Cost-efficient Sequential patterns"};
    }
}

