/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.cost.AlgoCEPM;
import java.io.IOException;

public class DescriptionAlgoCEPN
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "CEPN";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/CEPNcost.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minsup = DescriptionAlgoCEPN.getParamAsInteger(parameters[0]);
        double maxcost = DescriptionAlgoCEPN.getParamAsDouble(parameters[1]);
        double minOccupancy = DescriptionAlgoCEPN.getParamAsDouble(parameters[2]);
        boolean sortByUtility = false;
        boolean outputLowestTradeOff = false;
        int maxPatternLength = 999;
        if (parameters.length >= 4 && !"".equals(parameters[3])) {
            maxPatternLength = DescriptionAlgoCEPN.getParamAsInteger(parameters[3]);
        }
        if (parameters.length >= 5 && !"".equals(parameters[4])) {
            sortByUtility = DescriptionAlgoCEPN.getParamAsBoolean(parameters[4]);
        }
        if (parameters.length >= 6 && !"".equals(parameters[5])) {
            outputLowestTradeOff = DescriptionAlgoCEPN.getParamAsBoolean(parameters[5]);
        }
        AlgoCEPM algo = new AlgoCEPM();
        algo.setMaximumPatternLength(maxPatternLength);
        algo.runAlgorithmCEPN(inputFile, outputFile, minsup, maxcost, minOccupancy, sortByUtility, outputLowestTradeOff);
        algo.printStatistics();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup", "(e.g. 2)", Double.class, false), new DescriptionOfParameter("Maxcost", "(e.g. 50)", Integer.class, false), new DescriptionOfParameter("Minoccupancy", "(e.g. 0.1)", Double.class, false), new DescriptionOfParameter("Max pattern length", "", Integer.class, true), new DescriptionOfParameter("Sort by utility?", "(default: false)", Boolean.class, true), new DescriptionOfParameter("Only lowest trade-off?", "(default: false)", Boolean.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Jiaxuan Li";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Sequence Database with cost and numeric utility"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential patterns", "Cost-efficient Sequential patterns"};
    }
}

