/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.charm.AlgoCharm_Bitset;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class DescriptionAlgoCharmBitset
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "Charm_bitset";
    }

    @Override
    public String getAlgorithmCategory() {
        return "FREQUENT ITEMSET MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/Charm_dCharm.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoCharmBitset.getParamAsDouble(parameters[0]);
        AlgoCharm_Bitset algo = new AlgoCharm_Bitset();
        TransactionDatabase database = new TransactionDatabase();
        try {
            database.loadFile(inputFile);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (parameters.length >= 2 && !"".equals(parameters[1])) {
            algo.setShowTransactionIdentifiers(DescriptionAlgoCharmBitset.getParamAsBoolean(parameters[1]));
        }
        algo.runAlgorithm(outputFile, database, minsup, true, 10000);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.4 or 40%)", Double.class, false), new DescriptionOfParameter("Show transaction ids?", "(default: false)", Boolean.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Frequent patterns", "Frequent closed itemsets"};
    }
}

