/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.ffi_miner.AlgoFFIMiner;
import java.io.IOException;

public class DescriptionAlgoFFIMiner
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "FFI-Miner";
    }

    @Override
    public String getAlgorithmCategory() {
        return "FREQUENT ITEMSET MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/FFIMiner.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        float minSupport = DescriptionAlgoFFIMiner.getParamAsFloat(parameters[0]);
        AlgoFFIMiner FFIminer = new AlgoFFIMiner();
        FFIminer.runAlgorithm(inputFile, outputFile, minSupport);
        FFIminer.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minimum support", "(e.g. 2)", Float.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Ting Li";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Frequent patterns", "Frequent itemsets", "Frequent fuzzy itemsets"};
    }
}

