/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth.AlgoFPGrowth;
import java.io.IOException;

public class DescriptionAlgoFPGrowth
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "FPGrowth_itemsets";
    }

    @Override
    public String getAlgorithmCategory() {
        return "FREQUENT ITEMSET MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/FPGrowth.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoFPGrowth.getParamAsDouble(parameters[0]);
        AlgoFPGrowth algorithm = new AlgoFPGrowth();
        if (parameters.length >= 2 && !"".equals(parameters[1])) {
            algorithm.setMaximumPatternLength(DescriptionAlgoFPGrowth.getParamAsInteger(parameters[1]));
        }
        if (parameters.length >= 3 && !"".equals(parameters[2])) {
            algorithm.setMinimumPatternLength(DescriptionAlgoFPGrowth.getParamAsInteger(parameters[2]));
        }
        algorithm.runAlgorithm(inputFile, outputFile, minsup);
        algorithm.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.4 or 40%)", Double.class, false), new DescriptionOfParameter("Max pattern length", "(e.g. 2 items)", Integer.class, true), new DescriptionOfParameter("Min pattern length", "(e.g. 2 items)", Integer.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Frequent patterns", "Frequent itemsets"};
    }
}

