/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.AlgoHUGMiner;
import java.io.IOException;

public class DescriptionAlgoHUGMiner
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "HUG-Miner";
    }

    @Override
    public String getAlgorithmCategory() {
        return "HIGH-UTILITY PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/HUG-Miner.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minutil = DescriptionAlgoHUGMiner.getParamAsInteger(parameters[0]);
        AlgoHUGMiner hugMiner = new AlgoHUGMiner();
        hugMiner.runAlgorithm(inputFile, outputFile, minutil);
        hugMiner.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minimum utility", "(e.g. 20)", Integer.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Generator patterns", "High-utility patterns", "Generator itemsets", "High-utility itemsets", "High-utility generator itemsets"};
    }
}

