/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.clustering.instancereader.AlgoInstanceFileReader;
import ca.pfv.spmf.gui.instanceviewer.InstanceViewer;
import ca.pfv.spmf.patterns.cluster.DoubleArray;
import java.io.IOException;
import java.util.List;

public class DescriptionAlgoInstanceViewer
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "Vizualize_instances";
    }

    @Override
    public String getAlgorithmCategory() {
        return "CLUSTERING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/InstanceViewer.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        String separator = parameters.length > 0 && !"".equals(parameters[0]) ? DescriptionAlgoInstanceViewer.getParamAsString(parameters[0]) : " ";
        AlgoInstanceFileReader reader = new AlgoInstanceFileReader();
        List<DoubleArray> instances = reader.runAlgorithm(inputFile, separator);
        List<String> attributes = reader.getAttributeNames();
        InstanceViewer viewer = new InstanceViewer(instances, attributes);
        viewer.setVisible(true);
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("separator", "(e.g. ',' , default: ' ')", String.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Instances"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return null;
    }
}

