/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.memu.AlgoMEMU;
import java.io.File;
import java.io.IOException;

public class DescriptionAlgoMEMU
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "MEMU";
    }

    @Override
    public String getAlgorithmCategory() {
        return "HIGH-UTILITY PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/MEMU.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int beta = DescriptionAlgoMEMU.getParamAsInteger(parameters[0]);
        int glmau = DescriptionAlgoMEMU.getParamAsInteger(parameters[1]);
        String profitFile = DescriptionAlgoMEMU.getParamAsString(parameters[2]);
        File file = new File(inputFile);
        if (file.getParent() != null) {
            profitFile = file.getParent() + File.separator + profitFile;
        }
        AlgoMEMU algorithm = new AlgoMEMU();
        algorithm.runAlgorithm(profitFile, inputFile, outputFile, beta, glmau);
        algorithm.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("BETA", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("GLMAU", "(e.g. 25)", Integer.class, false), new DescriptionOfParameter("Profit file", "(e.g. UtilityDB_profit.txt)", String.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Shifeng Ren";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values (MEMU)"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "High-utility patterns", "High average-utility itemsets"};
    }
}

