/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.mpfps.AlgoMPFPS_BFS;

public class DescriptionAlgoMPFPSBFS
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "MPFPS-BFS";
    }

    @Override
    public String getAlgorithmCategory() {
        return "PERIODIC PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/MPFPS.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws Exception {
        double maxStandardDeviation = DescriptionAlgoMPFPSBFS.getParamAsDouble(parameters[0]);
        double minRA = DescriptionAlgoMPFPSBFS.getParamAsDouble(parameters[1]);
        int maxPeriodicity = DescriptionAlgoMPFPSBFS.getParamAsInteger(parameters[2]);
        int minimumSupport = DescriptionAlgoMPFPSBFS.getParamAsInteger(parameters[3]);
        AlgoMPFPS_BFS algorithm = new AlgoMPFPS_BFS();
        algorithm.runAlgorithm(maxStandardDeviation, minRA, maxPeriodicity, minimumSupport, inputFile, outputFile);
        algorithm.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("MaxStd (%)", "(e.g. 10)", Double.class, false), new DescriptionOfParameter("MinRA (%)", "(default: 0.25)", Double.class, false), new DescriptionOfParameter("MaxPer", "(e.g. 10)", Integer.class, false), new DescriptionOfParameter("Minsup", "(e.g. 2)", Integer.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Zhitian Li, Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Periodic patterns", "Periodic frequent patterns", "Periodic frequent itemsets common to multiple sequences"};
    }
}

