/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.MRCPPS.AlgoMRCPPS;

public class DescriptionAlgoMRCPPS
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "MRCPPS";
    }

    @Override
    public String getAlgorithmCategory() {
        return "PERIODIC PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/MRCPPS.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws Exception {
        int maxSup = DescriptionAlgoMRCPPS.getParamAsInteger(parameters[0]);
        double maxStd = DescriptionAlgoMRCPPS.getParamAsDouble(parameters[1]);
        double minBond = DescriptionAlgoMRCPPS.getParamAsDouble(parameters[2]);
        double minRa = DescriptionAlgoMRCPPS.getParamAsDouble(parameters[3]);
        AlgoMRCPPS algorithm = new AlgoMRCPPS();
        algorithm.runAlgorithm(inputFile, outputFile, maxSup, maxStd, minBond, minRa, true, false, 0);
        algorithm.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("MaxSup ", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("MaxStd ", "(default: 1)", Double.class, false), new DescriptionOfParameter("MinBond ", "(e.g. 0.5)", Double.class, false), new DescriptionOfParameter("MinRa ", "(e.g. 0.5)", Double.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Yang Peng, Zhitian Li, Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Periodic patterns", "Periodic rare patterns", "Rare correlated itemsets common to multiple sequences"};
    }
}

