/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.lhui.AlgoPHUIMiner;
import java.io.IOException;

public class DescriptionAlgoPHUIMiner
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "PHUI-Miner";
    }

    @Override
    public String getAlgorithmCategory() {
        return "HIGH-UTILITY PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/PHUIMiner.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int lminutil = DescriptionAlgoPHUIMiner.getParamAsInteger(parameters[0]);
        int windowSize = DescriptionAlgoPHUIMiner.getParamAsInteger(parameters[1]);
        double lambda = DescriptionAlgoPHUIMiner.getParamAsInteger(parameters[2]);
        AlgoPHUIMiner algorithm = new AlgoPHUIMiner();
        algorithm.runAlgorithm(inputFile, outputFile, lminutil, windowSize, lambda);
        algorithm.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minimum utility", "(e.g. 40)", Long.class, false), new DescriptionOfParameter("Window size", "(e.g. 3)", Integer.class, false), new DescriptionOfParameter("Lambda", "(e.g. 2)", Double.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Yimin Zhang, Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values and time"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "High-utility patterns", "Peak high-utility itemsets"};
    }
}

