/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.AlgoPrefixSpan_AGP;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.creators.AbstractionCreator_Qualitative;
import java.io.IOException;

public class DescriptionAlgoPrefixSpanAGP
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "PrefixSpan_AGP";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/PrefixSpan.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        AbstractionCreator_Qualitative abstractionCreator = AbstractionCreator_Qualitative.getInstance();
        double minSupport = DescriptionAlgoPrefixSpanAGP.getParamAsDouble(parameters[0]);
        boolean outputSeqIdentifiers = false;
        if (parameters.length >= 2 && !"".equals(parameters[1])) {
            outputSeqIdentifiers = DescriptionAlgoPrefixSpanAGP.getParamAsBoolean(parameters[1]);
        }
        AlgoPrefixSpan_AGP algo = new AlgoPrefixSpan_AGP(minSupport, abstractionCreator);
        SequenceDatabase sd = new SequenceDatabase(abstractionCreator);
        sd.loadFile(inputFile, minSupport);
        algo.runAlgorithm(sd, true, false, outputFile, outputSeqIdentifiers);
        System.out.println(algo.printStatistics());
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.4 or 40%)", Double.class, false), new DescriptionOfParameter("Show sequence ids?", "(default: false)", Boolean.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Antonio Gomariz Penalver";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential patterns", "Frequent sequential patterns"};
    }
}

