/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.qcsp.AlgoQCSP;

public class DescriptionAlgoQCSP
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "QCSP";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "https://bitbucket.org/len_feremans/qcsp_public";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws Exception {
        int minsup = DescriptionAlgoQCSP.getParamAsInteger(parameters[0]);
        double alpha = DescriptionAlgoQCSP.getParamAsDouble(parameters[1]);
        int maxsize = DescriptionAlgoQCSP.getParamAsInteger(parameters[2]);
        int k = DescriptionAlgoQCSP.getParamAsInteger(parameters[3]);
        String labelFile = null;
        if (parameters.length > 4 && (labelFile = parameters[4]).trim().equals("")) {
            labelFile = null;
        }
        AlgoQCSP algorithm = new AlgoQCSP();
        algorithm.setLabelsFile(labelFile);
        algorithm.runAlgorithm(inputFile, outputFile, minsup, alpha, maxsize, k);
        algorithm.printStatistics();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup ", "Frequency threshold on single item", Integer.class, false), new DescriptionOfParameter("Alpha ", "Cohesion threshold, e.g. 2 times pattern size", Double.class, false), new DescriptionOfParameter("Max pattern length", "", Integer.class, false), new DescriptionOfParameter("Top-k patterns", "", Integer.class, false), new DescriptionOfParameter("Label file name ", "(e.g. test_goKrimp.lab)", String.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Feremans et al.";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database", "Single sequence"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential patterns", "Top-k sequential patterns with quantile-based cohesion"};
    }
}

