/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.associationrules.agrawal94_association_rules.AlgoAgrawalFaster94;
import ca.pfv.spmf.algorithms.frequentpatterns.rpgrowth.AlgoRPGrowth;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets;
import java.io.IOException;

public class DescriptionAlgoRPGrowthAssociationRules
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "RPGrowth_association_rules";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/rpgrowthalgo.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoRPGrowthAssociationRules.getParamAsDouble(parameters[0]);
        double minraresup = DescriptionAlgoRPGrowthAssociationRules.getParamAsDouble(parameters[1]);
        double minconf = DescriptionAlgoRPGrowthAssociationRules.getParamAsDouble(parameters[2]);
        int maxAntecedentLength = 400;
        int maxConsequentLength = 400;
        if (parameters.length >= 4 && !"".equals(parameters[3])) {
            maxAntecedentLength = DescriptionAlgoRPGrowthAssociationRules.getParamAsInteger(parameters[3]);
        }
        if (parameters.length >= 5 && !"".equals(parameters[4])) {
            maxConsequentLength = DescriptionAlgoRPGrowthAssociationRules.getParamAsInteger(parameters[4]);
        }
        AlgoRPGrowth rpgrowth = new AlgoRPGrowth();
        rpgrowth.setMaximumPatternLength(maxAntecedentLength + maxConsequentLength);
        Itemsets patterns = rpgrowth.runAlgorithm(inputFile, null, minsup, minraresup);
        rpgrowth.printStats();
        int databaseSize = rpgrowth.getDatabaseSize();
        AlgoAgrawalFaster94 algoAgrawal = new AlgoAgrawalFaster94();
        algoAgrawal.setMaxAntecedentLength(maxAntecedentLength);
        algoAgrawal.setMaxConsequentLength(maxConsequentLength);
        algoAgrawal.runAlgorithm(patterns, outputFile, databaseSize, minconf);
        algoAgrawal.printStats();
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Ryan Benton and Blake Johns";
    }

    @Override
    public String getAlgorithmCategory() {
        return "ASSOCIATION RULE MINING";
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.5 or 50%)", Double.class, false), new DescriptionOfParameter("Minraresup (%)", "(e.g. 0.1 or 10%)", Double.class, false), new DescriptionOfParameter("Minconf (%)", "(e.g. 0.6 or 60%)", Double.class, false), new DescriptionOfParameter("Max antecedent length", "(e.g. 2 items)", Integer.class, true), new DescriptionOfParameter("Max consequent length", "(e.g. 2 items)", Integer.class, true)};
        return parameters;
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Association rules"};
    }
}

