/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.sppgrowth.AlgoSPPgrowth;
import java.io.IOException;

public class DescriptionAlgoSPPGrowth
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "SPPGrowth";
    }

    @Override
    public String getAlgorithmCategory() {
        return "PERIODIC PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/SPPGrowth.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int maxPer = DescriptionAlgoSPPGrowth.getParamAsInteger(parameters[0]);
        int minSup = DescriptionAlgoSPPGrowth.getParamAsInteger(parameters[1]);
        int maxLA = DescriptionAlgoSPPGrowth.getParamAsInteger(parameters[2]);
        boolean noTimestamps = DescriptionAlgoSPPGrowth.getParamAsBoolean(parameters[3]);
        AlgoSPPgrowth algo = new AlgoSPPgrowth();
        algo.runAlgorithm(inputFile, outputFile, maxPer, minSup, maxLA, noTimestamps);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Maximum periodicity", "(e.g. 2 transactions)", Integer.class, false), new DescriptionOfParameter("Minimum support", "(e.g. 3 transactions)", Integer.class, false), new DescriptionOfParameter("Maximum lability", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("Has no timestamps?", "(e.g. true)", Boolean.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Peng Yang and Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Frequent patterns", "Periodic patterns", "Periodic frequent patterns", "Stable Periodic frequent itemsets"};
    }
}

