/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.associationrules.agrawal94_association_rules.AlgoAgrawalFaster94;
import ca.pfv.spmf.algorithms.frequentpatterns.apriori_inverse.AlgoAprioriInverse;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets;
import java.io.IOException;

public class DescriptionAlgoSporadicAssociationRules
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "Sporadic_association_rules";
    }

    @Override
    public String getAlgorithmCategory() {
        return "ASSOCIATION RULE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/PerfectlySporadicAssociationRules.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoSporadicAssociationRules.getParamAsDouble(parameters[0]);
        double maxsup = DescriptionAlgoSporadicAssociationRules.getParamAsDouble(parameters[1]);
        double minconf = DescriptionAlgoSporadicAssociationRules.getParamAsDouble(parameters[2]);
        AlgoAprioriInverse apriori = new AlgoAprioriInverse();
        Itemsets patterns = apriori.runAlgorithm(minsup, maxsup, inputFile, null);
        apriori.printStats();
        int databaseSize = apriori.getDatabaseSize();
        AlgoAgrawalFaster94 algoAgrawal = new AlgoAgrawalFaster94();
        algoAgrawal.runAlgorithm(patterns, outputFile, databaseSize, minconf);
        algoAgrawal.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.1 or 10%)", Double.class, false), new DescriptionOfParameter("Maxsup (%)", "(e.g. 0.6 or 60%)", Double.class, false), new DescriptionOfParameter("Minconf (%)", "(e.g. 0.6 or 60%)", Double.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Association rules", "Sporadic association rules"};
    }
}

