/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.graph_mining.tkg.AlgoTKG;
import java.io.IOException;

public class DescriptionAlgoTKG
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "TKG";
    }

    @Override
    public String getAlgorithmCategory() {
        return "GRAPH PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/TKG.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException, ClassNotFoundException {
        int k = DescriptionAlgoTKG.getParamAsInteger(parameters[0]);
        int maxNumberOfEdges = Integer.MAX_VALUE;
        if (parameters.length >= 2 && !"".equals(parameters[1])) {
            maxNumberOfEdges = DescriptionAlgoTKG.getParamAsInteger(parameters[1]);
        }
        boolean outputSingleFrequentVertices = true;
        if (parameters.length >= 3 && !"".equals(parameters[2])) {
            outputSingleFrequentVertices = DescriptionAlgoTKG.getParamAsBoolean(parameters[2]);
        }
        boolean outputDotFile = false;
        if (parameters.length >= 4 && !"".equals(parameters[3])) {
            outputDotFile = DescriptionAlgoTKG.getParamAsBoolean(parameters[3]);
        }
        boolean outputGraphIds = true;
        if (parameters.length >= 5 && !"".equals(parameters[4])) {
            outputGraphIds = DescriptionAlgoTKG.getParamAsBoolean(parameters[4]);
        }
        AlgoTKG algo = new AlgoTKG();
        algo.runAlgorithm(inputFile, outputFile, k, outputSingleFrequentVertices, outputDotFile, maxNumberOfEdges, outputGraphIds);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("k", "(e.g. 3)", Double.class, false), new DescriptionOfParameter("Max Number of Edges", "(e.g. 2)", Boolean.class, true), new DescriptionOfParameter("Output Single Vertices", "(e.g. true)", Boolean.class, true), new DescriptionOfParameter("Output DOT file", "(e.g. false)", Boolean.class, true), new DescriptionOfParameter("Output Graph IDs", "(e.g. true)", Boolean.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger and Chao Cheng";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Graph database", "Labeled graph database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Subgraphs", "Top-k Frequent subgraphs"};
    }
}

