/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequential_rules.topseqrules_and_tns.AlgoTopSeqClassRules;
import ca.pfv.spmf.input.sequence_database_array_integers.SequenceDatabase;
import java.io.IOException;

public class DescriptionAlgoTopSeqClassRules
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "TopSeqClassRules";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL RULE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/TopSeqClassRules.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int k = DescriptionAlgoTopSeqClassRules.getParamAsInteger(parameters[0]);
        double minconf = DescriptionAlgoTopSeqClassRules.getParamAsDouble(parameters[1]);
        SequenceDatabase sequenceDatabase = new SequenceDatabase();
        sequenceDatabase.loadFile(inputFile);
        AlgoTopSeqClassRules algo = new AlgoTopSeqClassRules();
        String[] itemsString = parameters[2].split(",");
        int[] requiredItems = new int[itemsString.length];
        for (int i = 0; i < itemsString.length; ++i) {
            requiredItems[i] = Integer.parseInt(itemsString[i]);
        }
        if (parameters.length >= 4 && !"".equals(parameters[3])) {
            algo.setMaxAntecedentSize(DescriptionAlgoTopSeqClassRules.getParamAsInteger(parameters[3]));
        }
        algo.runAlgorithm(k, sequenceDatabase, minconf, requiredItems);
        algo.printStats();
        algo.writeResultTofile(outputFile);
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("k", "(e.g. 3 patterns)", Integer.class, false), new DescriptionOfParameter("Minconf (%)", "(e.g. 0.8 or 80%)", Double.class, false), new DescriptionOfParameter("Fixed consequent items", "(e.g. 1,2,3)", String.class, false), new DescriptionOfParameter("Max antecedent size", "(e.g. 1 items)", Integer.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential rules", "Top-k frequent sequential rules"};
    }
}

