/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.episodes.upspan.AlgoUP_Span;
import java.io.IOException;

public class DescriptionAlgoUP_SPAN
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "UP-SPAN";
    }

    @Override
    public String getAlgorithmCategory() {
        return "EPISODE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/UP_SPAN.PHP";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minutil = DescriptionAlgoUP_SPAN.getParamAsDouble(parameters[0]);
        int maxTimeDuration = DescriptionAlgoUP_SPAN.getParamAsInteger(parameters[1]);
        boolean outputSingleEvents = DescriptionAlgoUP_SPAN.getParamAsBoolean(parameters[2]);
        AlgoUP_Span algo = new AlgoUP_Span();
        algo.runAlgorithm(inputFile, outputFile, minutil, maxTimeDuration, outputSingleEvents);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minimum utility", "(e.g. 56%)", Double.class, false), new DescriptionOfParameter("Max. Time duration", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("Output single events", "(e.g. false)", Boolean.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Cheng-Wei Wu et al.";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Episodes", "High-utility patterns", "High-Utility episodes"};
    }
}

