/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.vhuqi.AlgoVHUQI;
import ca.pfv.spmf.algorithms.frequentpatterns.vhuqi.enumVHUQIMethod;
import java.io.File;
import java.io.IOException;

public class DescriptionAlgoVHUQI
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "VHUQI";
    }

    @Override
    public String getAlgorithmCategory() {
        return "HIGH-UTILITY PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/VHUQI.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        String inputProfitFile = DescriptionAlgoVHUQI.getParamAsString(parameters[0]);
        File file = new File(inputFile);
        if (file.getParent() != null) {
            inputProfitFile = file.getParent() + File.separator + inputProfitFile;
        }
        float minUtility = DescriptionAlgoVHUQI.getParamAsFloat(parameters[1]);
        int relativeCoefficient = DescriptionAlgoVHUQI.getParamAsInteger(parameters[2]);
        enumVHUQIMethod method = enumVHUQIMethod.valueOf(DescriptionAlgoVHUQI.getParamAsString(parameters[3]));
        AlgoVHUQI algo = new AlgoVHUQI();
        algo.runAlgorithm(inputFile, inputProfitFile, outputFile, minUtility, relativeCoefficient, method);
        algo.printStatistics();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Profit table", "(e.g. HUQI_DB_Profit.txt)", String.class, false), new DescriptionOfParameter("Minimum utility", "(e.g. 0.1)", Float.class, false), new DescriptionOfParameter("Relative coefficient", "(e.g. 7)", Integer.class, false), new DescriptionOfParameter("Method", "(e.g. MINC, MAXC, ALLC)", String.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Cheng-Wei Wu et al.";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values (HUQI)"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "High-utility patterns", "Quantitative high utility itemsets"};
    }
}

