/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.IGB;

import ca.pfv.spmf.algorithms.frequentpatterns.zart.TZTableClosed;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.patterns.rule_itemset_array_integer_with_count.Rule;
import ca.pfv.spmf.patterns.rule_itemset_array_integer_with_count.Rules;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class AlgoIGB {
    private TZTableClosed closedPatternsAndGenerators;
    private double minconf;
    private int databaseSize;
    private Rules rules;
    long startTimestamp = 0L;
    long endTimeStamp = 0L;
    private int ruleCount;
    BufferedWriter writer = null;

    public Rules runAlgorithm(TZTableClosed closedPatternsAndGenerators, int databaseSize, double minconf, String outputFilePath) throws IOException {
        if (outputFilePath == null) {
            this.writer = null;
            this.rules = new Rules("IGB ASSOCIATION RULES");
        } else {
            this.rules = null;
            this.writer = new BufferedWriter(new FileWriter(outputFilePath));
        }
        this.startTimestamp = System.currentTimeMillis();
        this.minconf = minconf;
        this.closedPatternsAndGenerators = closedPatternsAndGenerators;
        this.databaseSize = databaseSize;
        this.ruleCount = 0;
        for (List<Itemset> level : closedPatternsAndGenerators.levels) {
            for (Itemset itemset2 : level) {
                if (itemset2.size() == 0) continue;
                this.processItemset(itemset2);
            }
        }
        this.endTimeStamp = System.currentTimeMillis();
        if (this.writer != null) {
            this.writer.close();
        }
        return this.rules;
    }

    private void processItemset(Itemset i) throws IOException {
        Object object;
        if (i.getRelativeSupport(this.databaseSize) >= this.minconf) {
            this.save(new Itemset(), i, i.getAbsoluteSupport(), i.getRelativeSupport(this.databaseSize));
            return;
        }
        HashSet<Itemset> lSmallestPremise = new HashSet<Itemset>();
        for (int j = 0; j < i.size(); ++j) {
            for (Itemset i1 : this.closedPatternsAndGenerators.levels.get(j)) {
                if (!((double)i.getAbsoluteSupport() / (double)i1.getAbsoluteSupport() >= this.minconf) || !i.containsAll(i1)) continue;
                object = this.closedPatternsAndGenerators.mapGenerators.get(i1).iterator();
                while (object.hasNext()) {
                    Itemset genI1 = (Itemset)object.next();
                    boolean thereIsSmaller = false;
                    for (Itemset l : lSmallestPremise) {
                        if (!genI1.containsAll(l) || genI1.size() == l.size()) continue;
                        thereIsSmaller = true;
                        break;
                    }
                    if (thereIsSmaller) continue;
                    lSmallestPremise.add(genI1);
                }
            }
        }
        for (Itemset gs : lSmallestPremise) {
            ArrayList<Integer> list_i_gs = new ArrayList<Integer>();
            object = i.itemset;
            int genI1 = ((int[])object).length;
            for (int j = 0; j < genI1; ++j) {
                Integer item = object[j];
                if (gs.contains(item)) continue;
                list_i_gs.add(item);
            }
            int[] temp = new int[list_i_gs.size()];
            for (int k = 0; k < list_i_gs.size(); ++k) {
                temp[k] = (Integer)list_i_gs.get(k);
            }
            Itemset i_gs = new Itemset(temp);
            this.save(gs, i_gs, i.getAbsoluteSupport(), (double)i.getAbsoluteSupport() / (double)gs.getAbsoluteSupport());
        }
    }

    private void save(Itemset itemset1, Itemset itemset2, int absoluteSupport, double confidence) throws IOException {
        ++this.ruleCount;
        if (this.writer != null) {
            int i;
            StringBuilder buffer = new StringBuilder();
            if (itemset1.size() == 0) {
                buffer.append("__");
            } else {
                for (i = 0; i < itemset1.size(); ++i) {
                    buffer.append(itemset1.get(i));
                    if (i == itemset1.size() - 1) continue;
                    buffer.append(" ");
                }
            }
            buffer.append(" ==> ");
            for (i = 0; i < itemset2.size(); ++i) {
                buffer.append(itemset2.get(i));
                if (i == itemset2.size() - 1) continue;
                buffer.append(" ");
            }
            buffer.append(" #SUP: ");
            buffer.append(absoluteSupport);
            buffer.append(" #CONF: ");
            buffer.append(confidence);
            this.writer.write(buffer.toString());
            this.writer.newLine();
        } else {
            Rule rule = new Rule(itemset1.getItems(), itemset2.getItems(), itemset1.support, absoluteSupport, confidence);
            this.rules.addRule(rule);
        }
    }

    public void printStatistics() {
        System.out.println("============= IGB ASSOCIATION RULE GENERATION - STATS =============");
        System.out.println(" Number of association rules generated : " + this.ruleCount);
        System.out.println(" Total time ~ " + (this.endTimeStamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }
}

