/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.Indirect;

import ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemset;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoINDIRECT {
    Map<Integer, Set<Integer>> mapItemTIDS = new HashMap<Integer, Set<Integer>>();
    int minSuppRelative;
    double minconf = 0.0;
    double tsRelative = 0.0;
    long startTimestamp = 0L;
    long endTimeStamp = 0L;
    BufferedWriter writer = null;
    private int ruleCount;
    private int tidcount = 0;

    public void runAlgorithm(String input, String output, double minsup, double ts, double minconf) throws NumberFormatException, IOException {
        String line;
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.minconf = minconf;
        this.mapItemTIDS = new HashMap<Integer, Set<Integer>>();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        this.tidcount = 0;
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            for (String stringItem : lineSplited = line.split(" ")) {
                int item = Integer.parseInt(stringItem);
                Set<Integer> tids = this.mapItemTIDS.get(item);
                if (tids == null) {
                    tids = new HashSet<Integer>();
                    this.mapItemTIDS.put(item, tids);
                }
                tids.add(this.tidcount);
            }
            ++this.tidcount;
        }
        reader.close();
        this.minSuppRelative = (int)Math.ceil(minsup * (double)this.tidcount);
        this.tsRelative = (int)Math.ceil(ts * (double)this.tidcount);
        int k = 1;
        List<Itemset> level = new ArrayList<Itemset>();
        Iterator<Map.Entry<Integer, Set<Integer>>> iterator = this.mapItemTIDS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Set<Integer>> entry = iterator.next();
            if (entry.getValue().size() >= this.minSuppRelative) {
                Integer item = entry.getKey();
                Itemset itemset2 = new Itemset(item);
                itemset2.setTIDs(this.mapItemTIDS.get(item));
                level.add(itemset2);
                continue;
            }
            iterator.remove();
        }
        Collections.sort(level, new Comparator<Itemset>(){

            @Override
            public int compare(Itemset o1, Itemset o2) {
                return o1.get(0) - o2.get(0);
            }
        });
        k = 2;
        while (!level.isEmpty()) {
            level = this.generateCandidateSizeK(level, k);
            ++k;
        }
        this.writer.close();
        this.endTimeStamp = System.currentTimeMillis();
    }

    protected List<Itemset> generateCandidateSizeK(List<Itemset> levelK_1, int level) throws IOException {
        int i;
        ArrayList<Itemset> nextLevel = new ArrayList<Itemset>();
        block0: for (i = 0; i < levelK_1.size(); ++i) {
            Itemset itemset1 = levelK_1.get(i);
            block1: for (int j = i + 1; j < levelK_1.size(); ++j) {
                Itemset itemset2 = levelK_1.get(j);
                for (int k = 0; k < itemset1.size(); ++k) {
                    if (k == itemset1.size() - 1) {
                        if (itemset1.getItems()[k] < itemset2.get(k)) continue;
                        continue block0;
                    }
                    if (itemset1.getItems()[k] < itemset2.get(k)) continue block1;
                    if (itemset1.getItems()[k] > itemset2.get(k)) continue block0;
                }
                HashSet<Integer> list = new HashSet<Integer>();
                for (Integer val1 : itemset1.getTransactionsIds()) {
                    if (!itemset2.getTransactionsIds().contains(val1)) continue;
                    list.add(val1);
                }
                if (list.size() < this.minSuppRelative) continue;
                int[] newItemset = new int[itemset1.size() + 1];
                System.arraycopy(itemset1.itemset, 0, newItemset, 0, itemset1.size());
                newItemset[itemset1.size()] = itemset2.getItems()[itemset2.size() - 1];
                Itemset candidate = new Itemset(newItemset);
                candidate.setTIDs(list);
                nextLevel.add(candidate);
            }
        }
        if (level > 2) {
            for (i = 0; i < levelK_1.size(); ++i) {
                for (int j = i + 1; j < levelK_1.size(); ++j) {
                    Itemset candidate1 = levelK_1.get(i);
                    Itemset candidate2 = levelK_1.get(j);
                    int[] nArray = candidate1.getItems();
                    int n = nArray.length;
                    block6: for (int k = 0; k < n; ++k) {
                        Integer a = nArray[k];
                        if (candidate2.contains(a)) continue;
                        Integer b = null;
                        int[] nArray2 = candidate2.getItems();
                        int n2 = nArray2.length;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            Integer itemM = nArray2[i2];
                            if (candidate1.contains(itemM)) continue;
                            if (b != null) continue block6;
                            b = itemM;
                        }
                        this.testIndirectRule(candidate1, a, b);
                    }
                }
            }
        }
        return nextLevel;
    }

    private void testIndirectRule(Itemset itemset2, Integer a, Integer b) throws IOException {
        Set<Integer> tidsA = this.mapItemTIDS.get(a);
        Set<Integer> tidsB = this.mapItemTIDS.get(b);
        int supportAB = 0;
        for (Integer n : tidsA) {
            if (!tidsB.contains(n)) continue;
            ++supportAB;
        }
        if ((double)supportAB < this.tsRelative) {
            int supAY = 0;
            block1: for (Integer tidA : tidsA) {
                int[] nArray = itemset2.getItems();
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer item = nArray[i];
                    if (!item.equals(a) && !item.equals(b) && !this.mapItemTIDS.get(item).contains(tidA)) continue block1;
                }
                ++supAY;
            }
            double d = (double)supAY / (double)tidsA.size();
            if (d >= this.minconf) {
                int supBY = 0;
                block3: for (Integer tidB : tidsB) {
                    int[] nArray = itemset2.getItems();
                    int n = nArray.length;
                    for (int i = 0; i < n; ++i) {
                        Integer item = nArray[i];
                        if (!item.equals(a) && !item.equals(b) && !this.mapItemTIDS.get(item).contains(tidB)) continue block3;
                    }
                    ++supBY;
                }
                double confBY = (double)supBY / (double)tidsB.size();
                if (confBY >= this.minconf) {
                    this.saveRule(a, b, itemset2, d, confBY, supAY, supBY);
                }
            }
        }
    }

    private void saveRule(Integer a, Integer b, Itemset itemset2, double confAY, double confBY, int supAY, int supBY) throws IOException {
        ++this.ruleCount;
        StringBuilder buffer = new StringBuilder();
        buffer.append("(a= ");
        buffer.append(a);
        buffer.append(" b= ");
        buffer.append(b);
        buffer.append(" | mediator= ");
        for (int i = 0; i < itemset2.size(); ++i) {
            if (itemset2.get(i).equals(a) || itemset2.get(i).equals(b)) continue;
            buffer.append(itemset2.get(i));
            buffer.append(" ");
        }
        buffer.append(")");
        buffer.append(" #sup(a,mediator)= ");
        buffer.append(supAY);
        buffer.append(" #sup(b,mediator)= ");
        buffer.append(supBY);
        buffer.append(" #conf(a,mediator)= ");
        buffer.append(confAY);
        buffer.append(" #conf(b,mediator)= ");
        buffer.append(confBY);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() {
        System.out.println("=============  INDIRECT RULES GENERATION - STATS =============");
        System.out.println(" Transactions count from database : " + this.tidcount);
        System.out.println(" Indirect rule count : " + this.ruleCount);
        System.out.println(" Total time ~ " + (this.endTimeStamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }
}

