/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.MNRRules;

import ca.pfv.spmf.algorithms.frequentpatterns.zart.TZTableClosed;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.patterns.rule_itemset_array_integer_with_count.Rule;
import ca.pfv.spmf.patterns.rule_itemset_array_integer_with_count.Rules;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AlgoMNRRules {
    private TZTableClosed closedPatternsAndGenerators;
    private double minconf;
    private int databaseSize;
    long startTimestamp = 0L;
    long endTimeStamp = 0L;
    private int ruleCount;
    private Rules rules;
    BufferedWriter writer = null;

    public Rules runAlgorithm(String outputFilePath, double minconf, TZTableClosed closedPatternsAndGenerators, int databaseSize) throws IOException {
        if (outputFilePath == null) {
            this.writer = null;
            this.rules = new Rules("MNR association rules");
        } else {
            this.rules = null;
            this.writer = new BufferedWriter(new FileWriter(outputFilePath));
        }
        this.closedPatternsAndGenerators = closedPatternsAndGenerators;
        this.minconf = minconf;
        this.databaseSize = databaseSize;
        this.ruleCount = 0;
        this.startTimestamp = System.currentTimeMillis();
        for (Map.Entry<Itemset, List<Itemset>> entryEquivalenceClass : closedPatternsAndGenerators.mapGenerators.entrySet()) {
            List<Itemset> listGenerators = entryEquivalenceClass.getValue();
            if (listGenerators.size() == 0 && entryEquivalenceClass.getKey().size() != 0) {
                listGenerators.add(entryEquivalenceClass.getKey());
            }
            for (Itemset generatorG : listGenerators) {
                HashSet<Itemset> supersets = new HashSet<Itemset>();
                for (Itemset closedItemset : closedPatternsAndGenerators.mapGenerators.keySet()) {
                    if (generatorG.size() >= closedItemset.size() || !closedItemset.containsAll(generatorG)) continue;
                    supersets.add(closedItemset);
                }
                for (Itemset closedItemset : supersets) {
                    Itemset leftSide = generatorG;
                    Itemset rightSide = closedItemset.cloneItemSetMinusAnItemset(generatorG);
                    this.calculateSupport(rightSide);
                    double conf = (double)closedItemset.getAbsoluteSupport() / (double)generatorG.getAbsoluteSupport();
                    if (!(conf >= minconf)) continue;
                    this.saveRule(leftSide, rightSide, closedItemset.getAbsoluteSupport(), conf);
                }
            }
        }
        this.endTimeStamp = System.currentTimeMillis();
        if (this.writer != null) {
            this.writer.close();
        }
        return this.rules;
    }

    private void saveRule(Itemset itemset1, Itemset itemset2, int absoluteSupport, double confidence) throws IOException {
        ++this.ruleCount;
        if (this.writer != null) {
            int i;
            StringBuilder buffer = new StringBuilder();
            if (itemset1.size() == 0) {
                buffer.append("__");
            } else {
                for (i = 0; i < itemset1.size(); ++i) {
                    buffer.append(itemset1.get(i));
                    if (i == itemset1.size() - 1) continue;
                    buffer.append(" ");
                }
            }
            buffer.append(" ==> ");
            for (i = 0; i < itemset2.size(); ++i) {
                buffer.append(itemset2.get(i));
                if (i == itemset2.size() - 1) continue;
                buffer.append(" ");
            }
            buffer.append(" #SUP: ");
            buffer.append(absoluteSupport);
            buffer.append(" #CONF: ");
            buffer.append(confidence);
            this.writer.write(buffer.toString());
            this.writer.newLine();
        } else {
            this.rules.addRule(new Rule(itemset1.getItems(), itemset2.getItems(), itemset1.getAbsoluteSupport(), absoluteSupport, confidence));
        }
    }

    private void calculateSupport(Itemset itemsetToTest) {
        for (List<Itemset> list : this.closedPatternsAndGenerators.levels) {
            if (list.size() == 0 || list.get(0).size() < itemsetToTest.size()) continue;
            for (Itemset itemset2 : list) {
                if (!itemset2.containsAll(itemsetToTest)) continue;
                itemsetToTest.setAbsoluteSupport(itemset2.getAbsoluteSupport());
                return;
            }
        }
    }

    public void printStatistics() {
        System.out.println("============= MNR ASSOCIATION RULE GENERATION - STATS =============");
        System.out.println(" Number of association rules generated : " + this.ruleCount);
        System.out.println(" Total time ~ " + (this.endTimeStamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }
}

