/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR;

import ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR.ClassRuleG;
import ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR.Database;
import ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR.Transaction;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;

public class AlgoTopKClassRules {
    long timeStart = 0L;
    long timeEnd = 0L;
    double minConfidence;
    int k = 0;
    Database database;
    int minsuppRelative;
    BitSet[] tableItemTids;
    int[] tableItemCount;
    PriorityQueue<ClassRuleG> kRules;
    PriorityQueue<ClassRuleG> candidates;
    int maxCandidateCount = 0;
    int maxAntecedentSize = Integer.MAX_VALUE;
    int[] itemToBeUsedAsConsequent;
    private int maxSupportRelative = Integer.MAX_VALUE;
    private double maxSupport = Double.MAX_VALUE;

    public void runAlgorithm(int k, double minConfidence, Database database, int[] itemToBeUsedAsConsequent) {
        MemoryLogger.getInstance().reset();
        this.maxCandidateCount = 0;
        this.minConfidence = minConfidence;
        this.database = database;
        this.k = k;
        this.itemToBeUsedAsConsequent = itemToBeUsedAsConsequent;
        this.maxSupportRelative = (int)Math.ceil(this.maxSupport * (double)database.getTransactions().size());
        this.minsuppRelative = 1;
        this.tableItemTids = new BitSet[database.maxItem + 1];
        this.tableItemCount = new int[database.maxItem + 1];
        this.kRules = new PriorityQueue();
        this.candidates = new PriorityQueue<ClassRuleG>(new Comparator<ClassRuleG>(){

            @Override
            public int compare(ClassRuleG o1, ClassRuleG o2) {
                return -o1.compareTo(o2);
            }
        });
        this.timeStart = System.currentTimeMillis();
        if (this.maxAntecedentSize >= 1) {
            this.scanDatabase(database);
            this.start();
        }
        this.timeEnd = System.currentTimeMillis();
    }

    private void start() {
        ClassRuleG rule;
        for (int itemI = 0; itemI <= this.database.maxItem; ++itemI) {
            if (this.tableItemCount[itemI] < this.minsuppRelative) continue;
            BitSet tidsI = this.tableItemTids[itemI];
            for (int itemJ : this.itemToBeUsedAsConsequent) {
                if (itemI == itemJ || this.tableItemCount[itemJ] < this.minsuppRelative) continue;
                BitSet tidsJ = this.tableItemTids[itemJ];
                BitSet commonTids = (BitSet)tidsI.clone();
                commonTids.and(tidsJ);
                int support = commonTids.cardinality();
                if (support < this.minsuppRelative) continue;
                this.generateRuleSize11(itemI, tidsI, itemJ, tidsJ, commonTids, support);
            }
        }
        while (this.candidates.size() > 0 && (rule = this.candidates.poll()).getAbsoluteSupport() >= this.minsuppRelative) {
            this.expandL(rule);
        }
    }

    private void generateRuleSize11(Integer item1, BitSet tid1, int item2, BitSet tid2, BitSet commonTids, int cardinality) {
        Integer[] itemset1 = new Integer[]{item1};
        ClassRuleG ruleLR = new ClassRuleG(itemset1, item2, cardinality, tid1, commonTids, item1);
        double confidenceIJ = (double)cardinality / (double)this.tableItemCount[item1];
        if (confidenceIJ >= this.minConfidence) {
            this.save(ruleLR, cardinality);
        }
        if (ruleLR.getItemset1().length < this.maxAntecedentSize) {
            this.registerAsCandidate(ruleLR);
        }
    }

    private void registerAsCandidate(ClassRuleG rule) {
        this.candidates.add(rule);
        if (this.candidates.size() >= this.maxCandidateCount) {
            this.maxCandidateCount = this.candidates.size();
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void expandL(ClassRuleG ClassRuleG2) {
        if (ClassRuleG2.getItemset1().length == this.maxAntecedentSize) {
            return;
        }
        HashMap<Integer, BitSet> mapCountLeft = new HashMap<Integer, BitSet>();
        int tid = ClassRuleG2.common.nextSetBit(0);
        while (tid >= 0) {
            Integer item;
            Iterator<Integer> iter = this.database.getTransactions().get(tid).getItems().iterator();
            while (iter.hasNext() && ((item = iter.next()) >= ClassRuleG2.maxLeft || item >= ClassRuleG2.getItemset2())) {
                if (this.tableItemCount[item] < this.minsuppRelative) {
                    iter.remove();
                    continue;
                }
                if (item <= ClassRuleG2.maxLeft || item.intValue() == ClassRuleG2.getItemset2()) continue;
                BitSet tidsItem = (BitSet)mapCountLeft.get(item);
                if (tidsItem == null) {
                    tidsItem = new BitSet();
                    mapCountLeft.put(item, tidsItem);
                }
                tidsItem.set(tid);
            }
            tid = ClassRuleG2.common.nextSetBit(tid + 1);
        }
        if (ClassRuleG2.getItemset1().length < this.maxAntecedentSize) {
            for (Map.Entry entry : mapCountLeft.entrySet()) {
                BitSet tidsRule = (BitSet)entry.getValue();
                int ruleSupport = tidsRule.cardinality();
                if (ruleSupport < this.minsuppRelative) continue;
                Integer itemC = (Integer)entry.getKey();
                BitSet tidsLeft = (BitSet)ClassRuleG2.tids1.clone();
                tidsLeft.and(this.tableItemTids[itemC]);
                Integer[] newLeftItemset = new Integer[ClassRuleG2.getItemset1().length + 1];
                System.arraycopy(ClassRuleG2.getItemset1(), 0, newLeftItemset, 0, ClassRuleG2.getItemset1().length);
                newLeftItemset[ClassRuleG2.getItemset1().length] = itemC;
                int maxLeft = itemC >= ClassRuleG2.maxLeft ? itemC : ClassRuleG2.maxLeft;
                double confidence = (double)ruleSupport / (double)tidsLeft.cardinality();
                ClassRuleG candidate = new ClassRuleG(newLeftItemset, ClassRuleG2.getItemset2(), ruleSupport, tidsLeft, tidsRule, maxLeft);
                if (confidence >= this.minConfidence) {
                    this.save(candidate, ruleSupport);
                }
                this.registerAsCandidate(candidate);
            }
        }
    }

    private void save(ClassRuleG rule, int support) {
        if (support > this.maxSupportRelative) {
            return;
        }
        this.kRules.add(rule);
        if (this.kRules.size() > this.k) {
            if (support > this.minsuppRelative) {
                do {
                    this.kRules.poll();
                } while (this.kRules.size() > this.k);
            }
            this.minsuppRelative = this.kRules.peek().getAbsoluteSupport();
        }
    }

    private void scanDatabase(Database database) {
        for (int j = 0; j < database.getTransactions().size(); ++j) {
            Transaction transaction = database.getTransactions().get(j);
            for (Integer item : transaction.getItems()) {
                BitSet ids = this.tableItemTids[item];
                if (ids == null) {
                    this.tableItemTids[item.intValue()] = new BitSet(database.tidsCount);
                }
                this.tableItemTids[item].set(j);
                this.tableItemCount[item.intValue()] = this.tableItemCount[item] + 1;
            }
        }
    }

    public void printStats() {
        System.out.println("=============  TOP-K CLASS RULES SPMF v.2.28 - STATS =============");
        System.out.println("Minsup : " + this.minsuppRelative);
        if ((double)this.maxSupportRelative < Double.MAX_VALUE) {
            System.out.println("Maxsup : " + this.maxSupportRelative);
        }
        System.out.println("Rules count: " + this.kRules.size());
        System.out.println("Memory : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println("Total time : " + (this.timeEnd - this.timeStart) + " ms");
        System.out.println("===================================================");
    }

    public void writeResultTofile(String path) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(path));
        if (this.kRules.size() > 0) {
            Object[] rules = this.kRules.toArray();
            Arrays.sort(rules);
            for (Object ruleObj : rules) {
                ClassRuleG rule = (ClassRuleG)ruleObj;
                StringBuilder buffer = new StringBuilder();
                buffer.append(rule.toString());
                buffer.append(" #SUP: ");
                buffer.append(rule.getAbsoluteSupport());
                buffer.append(" #CONF: ");
                buffer.append(rule.getConfidence());
                writer.write(buffer.toString());
                writer.newLine();
            }
        }
        writer.close();
    }

    public void setMaxAntecedentSize(int maxAntecedentSize) {
        this.maxAntecedentSize = maxAntecedentSize;
    }

    public void setMaxSupport(double maxSupport) {
        this.maxSupport = maxSupport;
    }
}

