/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR.Database;
import ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR.RuleG;
import ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR.Transaction;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;

public class AlgoTopKRules {
    long timeStart = 0L;
    long timeEnd = 0L;
    double minConfidence;
    int k = 0;
    Database database;
    int minsuppRelative;
    BitSet[] tableItemTids;
    int[] tableItemCount;
    PriorityQueue<RuleG> kRules;
    PriorityQueue<RuleG> candidates;
    int maxCandidateCount = 0;
    int maxAntecedentSize = Integer.MAX_VALUE;
    int maxConsequentSize = Integer.MAX_VALUE;

    public void runAlgorithm(int k, double minConfidence, Database database) {
        MemoryLogger.getInstance().reset();
        this.maxCandidateCount = 0;
        this.minConfidence = minConfidence;
        this.database = database;
        this.k = k;
        this.minsuppRelative = 1;
        this.tableItemTids = new BitSet[database.maxItem + 1];
        this.tableItemCount = new int[database.maxItem + 1];
        this.kRules = new PriorityQueue();
        this.candidates = new PriorityQueue<RuleG>(new Comparator<RuleG>(){

            @Override
            public int compare(RuleG o1, RuleG o2) {
                return -o1.compareTo(o2);
            }
        });
        this.timeStart = System.currentTimeMillis();
        if (this.maxAntecedentSize >= 1 && this.maxConsequentSize >= 1) {
            this.scanDatabase(database);
            this.start();
        }
        this.timeEnd = System.currentTimeMillis();
    }

    private void start() {
        RuleG rule;
        for (int itemI = 0; itemI <= this.database.maxItem; ++itemI) {
            if (this.tableItemCount[itemI] < this.minsuppRelative) continue;
            BitSet tidsI = this.tableItemTids[itemI];
            for (int itemJ = itemI + 1; itemJ <= this.database.maxItem; ++itemJ) {
                if (this.tableItemCount[itemJ] < this.minsuppRelative) continue;
                BitSet tidsJ = this.tableItemTids[itemJ];
                BitSet commonTids = (BitSet)tidsI.clone();
                commonTids.and(tidsJ);
                int support = commonTids.cardinality();
                if (support < this.minsuppRelative) continue;
                this.generateRuleSize11(itemI, tidsI, itemJ, tidsJ, commonTids, support);
            }
        }
        while (this.candidates.size() > 0 && (rule = this.candidates.poll()).getAbsoluteSupport() >= this.minsuppRelative) {
            if (rule.expandLR) {
                this.expandLR(rule);
                continue;
            }
            this.expandR(rule);
        }
    }

    private void generateRuleSize11(Integer item1, BitSet tid1, Integer item2, BitSet tid2, BitSet commonTids, int cardinality) {
        Integer[] itemset1 = new Integer[]{item1};
        Integer[] itemset2 = new Integer[]{item2};
        RuleG ruleLR = new RuleG(itemset1, itemset2, cardinality, tid1, commonTids, item1, item2);
        double confidenceIJ = (double)cardinality / (double)this.tableItemCount[item1];
        if (confidenceIJ >= this.minConfidence) {
            this.save(ruleLR, cardinality);
        }
        if (ruleLR.getItemset1().length < this.maxAntecedentSize || ruleLR.getItemset2().length < this.maxConsequentSize) {
            this.registerAsCandidate(true, ruleLR);
        }
        double confidenceJI = (double)cardinality / (double)this.tableItemCount[item2];
        RuleG ruleRL = new RuleG(itemset2, itemset1, cardinality, tid2, commonTids, item2, item1);
        if (confidenceJI >= this.minConfidence) {
            this.save(ruleRL, cardinality);
        }
        if (ruleRL.getItemset1().length < this.maxAntecedentSize || ruleRL.getItemset2().length < this.maxConsequentSize) {
            this.registerAsCandidate(true, ruleRL);
        }
    }

    private void registerAsCandidate(boolean expandLR, RuleG rule) {
        rule.expandLR = expandLR;
        this.candidates.add(rule);
        if (this.candidates.size() >= this.maxCandidateCount) {
            this.maxCandidateCount = this.candidates.size();
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void expandLR(RuleG ruleG) {
        Integer itemC;
        BitSet tidsRule;
        if (ruleG.getItemset2().length == this.maxConsequentSize && ruleG.getItemset1().length == this.maxAntecedentSize) {
            return;
        }
        HashMap<Integer, BitSet> mapCountLeft = new HashMap<Integer, BitSet>();
        HashMap<Integer, BitSet> mapCountRight = new HashMap<Integer, BitSet>();
        int tid = ruleG.common.nextSetBit(0);
        while (tid >= 0) {
            Integer item;
            Iterator<Integer> iter = this.database.getTransactions().get(tid).getItems().iterator();
            while (iter.hasNext() && ((item = iter.next()) >= ruleG.maxLeft || item >= ruleG.maxRight)) {
                BitSet tidsItem;
                if (this.tableItemCount[item] < this.minsuppRelative) {
                    iter.remove();
                    continue;
                }
                if (item > ruleG.maxLeft && !ArraysAlgos.containsLEX(ruleG.getItemset2(), item, ruleG.maxRight)) {
                    tidsItem = (BitSet)mapCountLeft.get(item);
                    if (tidsItem == null) {
                        tidsItem = new BitSet();
                        mapCountLeft.put(item, tidsItem);
                    }
                    tidsItem.set(tid);
                }
                if (item <= ruleG.maxRight || ArraysAlgos.containsLEX(ruleG.getItemset1(), item, ruleG.maxLeft)) continue;
                tidsItem = (BitSet)mapCountRight.get(item);
                if (tidsItem == null) {
                    tidsItem = new BitSet();
                    mapCountRight.put(item, tidsItem);
                }
                tidsItem.set(tid);
            }
            tid = ruleG.common.nextSetBit(tid + 1);
        }
        if (ruleG.getItemset2().length < this.maxConsequentSize) {
            for (Map.Entry entry : mapCountRight.entrySet()) {
                tidsRule = (BitSet)entry.getValue();
                int ruleSupport = tidsRule.cardinality();
                if (ruleSupport < this.minsuppRelative) continue;
                itemC = (Integer)entry.getKey();
                Integer[] newRightItemset = new Integer[ruleG.getItemset2().length + 1];
                System.arraycopy(ruleG.getItemset2(), 0, newRightItemset, 0, ruleG.getItemset2().length);
                newRightItemset[ruleG.getItemset2().length] = itemC;
                int maxRight = itemC >= ruleG.maxRight ? itemC : ruleG.maxRight;
                double confidence = (double)ruleSupport / (double)ruleG.tids1.cardinality();
                RuleG candidate = new RuleG(ruleG.getItemset1(), newRightItemset, ruleSupport, ruleG.tids1, tidsRule, ruleG.maxLeft, maxRight);
                if (confidence >= this.minConfidence) {
                    this.save(candidate, ruleSupport);
                }
                if (candidate.getItemset2().length >= this.maxConsequentSize) continue;
                this.registerAsCandidate(false, candidate);
            }
        }
        if (ruleG.getItemset1().length < this.maxAntecedentSize) {
            for (Map.Entry entry : mapCountLeft.entrySet()) {
                tidsRule = (BitSet)entry.getValue();
                int ruleSupport = tidsRule.cardinality();
                if (ruleSupport < this.minsuppRelative) continue;
                itemC = (Integer)entry.getKey();
                BitSet tidsLeft = (BitSet)ruleG.tids1.clone();
                tidsLeft.and(this.tableItemTids[itemC]);
                Integer[] newLeftItemset = new Integer[ruleG.getItemset1().length + 1];
                System.arraycopy(ruleG.getItemset1(), 0, newLeftItemset, 0, ruleG.getItemset1().length);
                newLeftItemset[ruleG.getItemset1().length] = itemC;
                int maxLeft = itemC >= ruleG.maxLeft ? itemC : ruleG.maxLeft;
                double confidence = (double)ruleSupport / (double)tidsLeft.cardinality();
                RuleG candidate = new RuleG(newLeftItemset, ruleG.getItemset2(), ruleSupport, tidsLeft, tidsRule, maxLeft, ruleG.maxRight);
                if (confidence >= this.minConfidence) {
                    this.save(candidate, ruleSupport);
                }
                if (candidate.getItemset1().length >= this.maxAntecedentSize && candidate.getItemset2().length >= this.maxConsequentSize) continue;
                this.registerAsCandidate(true, candidate);
            }
        }
    }

    private void expandR(RuleG ruleG) {
        if (ruleG.getItemset2().length == this.maxConsequentSize) {
            return;
        }
        HashMap<Integer, BitSet> mapCountRight = new HashMap<Integer, BitSet>();
        int tid = ruleG.common.nextSetBit(0);
        while (tid >= 0) {
            Iterator<Integer> iter = this.database.getTransactions().get(tid).getItems().iterator();
            while (iter.hasNext()) {
                Integer item = iter.next();
                if (this.tableItemCount[item] < this.minsuppRelative) {
                    iter.remove();
                    continue;
                }
                if (item < ruleG.maxRight) break;
                if (item <= ruleG.maxRight || ArraysAlgos.containsLEX(ruleG.getItemset1(), item, ruleG.maxLeft)) continue;
                BitSet tidsItem = (BitSet)mapCountRight.get(item);
                if (tidsItem == null) {
                    tidsItem = new BitSet();
                    mapCountRight.put(item, tidsItem);
                }
                tidsItem.set(tid);
            }
            tid = ruleG.common.nextSetBit(tid + 1);
        }
        for (Map.Entry entry : mapCountRight.entrySet()) {
            BitSet tidsRule = (BitSet)entry.getValue();
            int ruleSupport = tidsRule.cardinality();
            if (ruleSupport < this.minsuppRelative) continue;
            Integer itemC = (Integer)entry.getKey();
            Integer[] newRightItemset = new Integer[ruleG.getItemset2().length + 1];
            System.arraycopy(ruleG.getItemset2(), 0, newRightItemset, 0, ruleG.getItemset2().length);
            newRightItemset[ruleG.getItemset2().length] = itemC;
            int maxRight = itemC >= ruleG.maxRight ? itemC : ruleG.maxRight;
            double confidence = (double)ruleSupport / (double)ruleG.tids1.cardinality();
            RuleG candidate = new RuleG(ruleG.getItemset1(), newRightItemset, ruleSupport, ruleG.tids1, tidsRule, ruleG.maxLeft, maxRight);
            if (confidence >= this.minConfidence) {
                this.save(candidate, ruleSupport);
            }
            if (candidate.getItemset2().length >= this.maxConsequentSize) continue;
            this.registerAsCandidate(false, candidate);
        }
    }

    private void save(RuleG rule, int support) {
        this.kRules.add(rule);
        if (this.kRules.size() > this.k) {
            if (support > this.minsuppRelative) {
                do {
                    this.kRules.poll();
                } while (this.kRules.size() > this.k);
            }
            this.minsuppRelative = this.kRules.peek().getAbsoluteSupport();
        }
    }

    private void scanDatabase(Database database) {
        for (int j = 0; j < database.getTransactions().size(); ++j) {
            Transaction transaction = database.getTransactions().get(j);
            for (Integer item : transaction.getItems()) {
                BitSet ids = this.tableItemTids[item];
                if (ids == null) {
                    this.tableItemTids[item.intValue()] = new BitSet(database.tidsCount);
                }
                this.tableItemTids[item].set(j);
                this.tableItemCount[item.intValue()] = this.tableItemCount[item] + 1;
            }
        }
    }

    public void printStats() {
        System.out.println("=============  TOP-K RULES SPMF v.2.10 - STATS =============");
        System.out.println("Minsup : " + this.minsuppRelative);
        System.out.println("Rules count: " + this.kRules.size());
        System.out.println("Memory : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println("Total time : " + (this.timeEnd - this.timeStart) + " ms");
        System.out.println("===================================================");
    }

    public void writeResultTofile(String path) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(path));
        if (this.kRules.size() > 0) {
            Object[] rules = this.kRules.toArray();
            Arrays.sort(rules);
            for (Object ruleObj : rules) {
                RuleG rule = (RuleG)ruleObj;
                StringBuilder buffer = new StringBuilder();
                buffer.append(rule.toString());
                buffer.append(" #SUP: ");
                buffer.append(rule.getAbsoluteSupport());
                buffer.append(" #CONF: ");
                buffer.append(rule.getConfidence());
                writer.write(buffer.toString());
                writer.newLine();
            }
        }
        writer.close();
    }

    public void setMaxAntecedentSize(int maxAntecedentSize) {
        this.maxAntecedentSize = maxAntecedentSize;
    }

    public void setMaxConsequentSize(int maxConsequentSize) {
        this.maxConsequentSize = maxConsequentSize;
    }
}

