/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.agrawal94_association_rules;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.associationrules.agrawal94_association_rules.AssocRule;
import ca.pfv.spmf.algorithms.associationrules.agrawal94_association_rules.AssocRules;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AlgoAgrawalFaster94 {
    protected Itemsets patterns;
    protected AssocRules rules;
    protected BufferedWriter writer = null;
    protected long startTimestamp = 0L;
    protected long endTimeStamp = 0L;
    protected int ruleCount = 0;
    protected int databaseSize = 0;
    private int maxConsequentLength = Integer.MAX_VALUE;
    private int maxAntecedentLength = Integer.MAX_VALUE;
    protected double minconf;
    protected double minlift;
    protected boolean usingLift = true;

    public AssocRules runAlgorithm(Itemsets patterns, String output, int databaseSize, double minconf) throws IOException {
        this.minconf = minconf;
        this.minlift = 0.0;
        this.usingLift = false;
        return this.runAlgorithm(patterns, output, databaseSize);
    }

    public AssocRules runAlgorithm(Itemsets patterns, String output, int databaseSize, double minconf, double minlift) throws IOException {
        this.minconf = minconf;
        this.minlift = minlift;
        this.usingLift = true;
        return this.runAlgorithm(patterns, output, databaseSize);
    }

    private AssocRules runAlgorithm(Itemsets patterns, String output, int databaseSize) throws IOException {
        if (this.maxAntecedentLength < 1 || this.maxConsequentLength < 1) {
            throw new IllegalArgumentException("The maximum length must be at least 1.");
        }
        if (output == null) {
            this.writer = null;
            this.rules = new AssocRules("ASSOCIATION RULES");
        } else {
            this.rules = null;
            this.writer = new BufferedWriter(new FileWriter(output));
        }
        this.databaseSize = databaseSize;
        this.startTimestamp = System.currentTimeMillis();
        this.ruleCount = 0;
        this.patterns = patterns;
        for (List<Itemset> itemsetsSameSize : patterns.getLevels()) {
            Collections.sort(itemsetsSameSize, new Comparator<Itemset>(){

                @Override
                public int compare(Itemset o1, Itemset o2) {
                    return ArraysAlgos.comparatorItemsetSameSize.compare(o1.getItems(), o2.getItems());
                }
            });
        }
        for (int k = 2; k < patterns.getLevels().size(); ++k) {
            for (Itemset lk : patterns.getLevels().get(k)) {
                ArrayList<int[]> H1_for_recursion = new ArrayList<int[]>();
                for (int item : lk.getItems()) {
                    int[] itemsetHm_P_1 = new int[]{item};
                    if (lk.size() - 1 <= this.maxAntecedentLength) {
                        int[] itemset_Lk_minus_hm_P_1 = ArraysAlgos.cloneItemSetMinusOneItem(lk.getItems(), item);
                        int support = this.calculateSupport(itemset_Lk_minus_hm_P_1);
                        double supportAsDouble = support;
                        double conf = (double)lk.getAbsoluteSupport() / supportAsDouble;
                        if (conf < this.minconf || Double.isInfinite(conf)) continue;
                        double lift = 0.0;
                        int supportHm_P_1 = 0;
                        if (this.usingLift) {
                            double term3;
                            double term2;
                            supportHm_P_1 = this.calculateSupport(itemsetHm_P_1);
                            double term1 = (double)lk.getAbsoluteSupport() / (double)databaseSize;
                            lift = term1 / ((term2 = supportAsDouble / (double)databaseSize) * (term3 = (double)supportHm_P_1 / (double)databaseSize));
                            if (lift < this.minlift) continue;
                        }
                        this.saveRule(itemset_Lk_minus_hm_P_1, support, itemsetHm_P_1, supportHm_P_1, lk.getAbsoluteSupport(), conf, lift);
                    }
                    if (1 >= this.maxConsequentLength) continue;
                    H1_for_recursion.add(itemsetHm_P_1);
                }
                this.apGenrules(k, 1, lk, H1_for_recursion);
            }
        }
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTimeStamp = System.currentTimeMillis();
        return this.rules;
    }

    private void apGenrules(int k, int m, Itemset lk, List<int[]> Hm) throws IOException {
        if (k > m + 1) {
            ArrayList<int[]> Hm_plus_1_for_recursion = new ArrayList<int[]>();
            List<int[]> Hm_plus_1 = this.generateCandidateSizeK(Hm);
            for (int[] hm_P_1 : Hm_plus_1) {
                if (lk.size() - hm_P_1.length <= this.maxAntecedentLength) {
                    int[] itemset_Lk_minus_hm_P_1 = ArraysAlgos.cloneItemSetMinusAnItemset(lk.getItems(), hm_P_1);
                    int support = this.calculateSupport(itemset_Lk_minus_hm_P_1);
                    double supportAsDouble = support;
                    double conf = (double)lk.getAbsoluteSupport() / supportAsDouble;
                    if (conf < this.minconf || Double.isInfinite(conf)) continue;
                    double lift = 0.0;
                    int supportHm_P_1 = 0;
                    if (this.usingLift) {
                        double term2;
                        supportHm_P_1 = this.calculateSupport(hm_P_1);
                        double term1 = (double)lk.getAbsoluteSupport() / (double)this.databaseSize;
                        lift = term1 / ((term2 = supportAsDouble / (double)this.databaseSize) * ((double)supportHm_P_1 / (double)this.databaseSize));
                        if (lift < this.minlift) continue;
                    }
                    this.saveRule(itemset_Lk_minus_hm_P_1, support, hm_P_1, supportHm_P_1, lk.getAbsoluteSupport(), conf, lift);
                }
                if (k == m + 1 || m + hm_P_1.length > this.maxConsequentLength) continue;
                Hm_plus_1_for_recursion.add(hm_P_1);
            }
            this.apGenrules(k, m + 1, lk, Hm_plus_1_for_recursion);
        }
    }

    private int calculateSupport(int[] itemset2) {
        List<Itemset> patternsSameSize = this.patterns.getLevels().get(itemset2.length);
        int first = 0;
        int last = patternsSameSize.size() - 1;
        while (first <= last) {
            int middle = first + last >> 1;
            int[] itemsetMiddle = patternsSameSize.get(middle).getItems();
            int comparison = ArraysAlgos.comparatorItemsetSameSize.compare(itemset2, itemsetMiddle);
            if (comparison > 0) {
                first = middle + 1;
                continue;
            }
            if (comparison < 0) {
                last = middle - 1;
                continue;
            }
            return patternsSameSize.get(middle).getAbsoluteSupport();
        }
        return 0;
    }

    protected List<int[]> generateCandidateSizeK(List<int[]> levelK_1) {
        ArrayList<int[]> candidates = new ArrayList<int[]>();
        block0: for (int i = 0; i < levelK_1.size(); ++i) {
            int[] itemset1 = levelK_1.get(i);
            block1: for (int j = i + 1; j < levelK_1.size(); ++j) {
                int[] newItemset;
                int[] itemset2 = levelK_1.get(j);
                for (int k = 0; k < itemset1.length; ++k) {
                    if (k == itemset1.length - 1) {
                        if (itemset1[k] < itemset2[k]) continue;
                        continue block0;
                    }
                    if (itemset1[k] < itemset2[k]) continue block1;
                    if (itemset1[k] > itemset2[k]) continue block0;
                }
                int lastItem1 = itemset1[itemset1.length - 1];
                int lastItem2 = itemset2[itemset2.length - 1];
                if (lastItem1 < lastItem2) {
                    newItemset = new int[itemset1.length + 1];
                    System.arraycopy(itemset1, 0, newItemset, 0, itemset1.length);
                    newItemset[itemset1.length] = lastItem2;
                    candidates.add(newItemset);
                    continue;
                }
                newItemset = new int[itemset1.length + 1];
                System.arraycopy(itemset2, 0, newItemset, 0, itemset2.length);
                newItemset[itemset2.length] = lastItem1;
                candidates.add(newItemset);
            }
        }
        return candidates;
    }

    public void printStats() {
        System.out.println("=============  ASSOCIATION RULE GENERATION v2.19- STATS =============");
        System.out.println(" Number of association rules generated : " + this.ruleCount);
        System.out.println(" Total time ~ " + (this.endTimeStamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }

    protected void saveRule(int[] itemset1, int supportItemset1, int[] itemset2, int supportItemset2, int absoluteSupport, double conf, double lift) throws IOException {
        ++this.ruleCount;
        if (this.writer != null) {
            int i;
            StringBuilder buffer = new StringBuilder();
            for (i = 0; i < itemset1.length; ++i) {
                buffer.append(itemset1[i]);
                if (i == itemset1.length - 1) continue;
                buffer.append(" ");
            }
            buffer.append(" ==> ");
            for (i = 0; i < itemset2.length; ++i) {
                buffer.append(itemset2[i]);
                if (i == itemset2.length - 1) continue;
                buffer.append(" ");
            }
            buffer.append(" #SUP: ");
            buffer.append(absoluteSupport);
            buffer.append(" #CONF: ");
            buffer.append(conf);
            if (this.usingLift) {
                buffer.append(" #LIFT: ");
                buffer.append(lift);
            }
            this.writer.write(buffer.toString());
            this.writer.newLine();
        } else {
            this.rules.addRule(new AssocRule(itemset1, itemset2, supportItemset1, absoluteSupport, conf, lift));
        }
    }

    public void setMaxAntecedentLength(int maxAntecedentLength) {
        this.maxAntecedentLength = maxAntecedentLength;
    }

    public void setMaxConsequentLength(int maxConsequentLength) {
        this.maxConsequentLength = maxConsequentLength;
    }
}

