/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.closedrules;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.associationrules.agrawal94_association_rules.AlgoAgrawalFaster94;
import ca.pfv.spmf.algorithms.associationrules.agrawal94_association_rules.AssocRules;
import ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth.CFITree;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AlgoClosedRules_UsingFPClose
extends AlgoAgrawalFaster94 {
    private CFITree cfiTree;

    public AssocRules runAlgorithm(Itemsets patterns, String output, int databaseSize, double minconf, CFITree cfiTree) throws IOException {
        this.minconf = minconf;
        this.minlift = 0.0;
        this.cfiTree = cfiTree;
        this.usingLift = false;
        return this.runAlgorithm(patterns, output, databaseSize);
    }

    public AssocRules runAlgorithm(Itemsets patterns, String output, int databaseSize, double minconf, double minlift, CFITree cfiTree) throws IOException {
        this.minconf = minconf;
        this.cfiTree = cfiTree;
        this.usingLift = true;
        return this.runAlgorithm(patterns, output, databaseSize);
    }

    private AssocRules runAlgorithm(Itemsets patterns, String output, int databaseSize) throws IOException {
        if (output == null) {
            this.writer = null;
            this.rules = new AssocRules("ASSOCIATION RULES");
        } else {
            this.rules = null;
            this.writer = new BufferedWriter(new FileWriter(output));
        }
        this.databaseSize = databaseSize;
        this.startTimestamp = System.currentTimeMillis();
        this.ruleCount = 0;
        this.patterns = patterns;
        for (List<Itemset> itemsetsSameSize : patterns.getLevels()) {
            Collections.sort(itemsetsSameSize, new Comparator<Itemset>(){

                @Override
                public int compare(Itemset o1, Itemset o2) {
                    return ArraysAlgos.comparatorItemsetSameSize.compare(o1.getItems(), o2.getItems());
                }
            });
        }
        for (int k = 2; k < patterns.getLevels().size(); ++k) {
            for (Itemset lk : patterns.getLevels().get(k)) {
                ArrayList<int[]> H1_for_recursion = new ArrayList<int[]>();
                for (int item : lk.getItems()) {
                    int[] itemsetHm_P_1 = new int[]{item};
                    int[] itemset_Lk_minus_hm_P_1 = ArraysAlgos.cloneItemSetMinusOneItem(lk.getItems(), item);
                    int support = this.calculateSupport(itemset_Lk_minus_hm_P_1);
                    double supportAsDouble = support;
                    double conf = (double)lk.getAbsoluteSupport() / supportAsDouble;
                    if (conf < this.minconf || Double.isInfinite(conf)) continue;
                    double lift = 0.0;
                    int supportHm_P_1 = 0;
                    if (this.usingLift) {
                        double term3;
                        double term2;
                        supportHm_P_1 = this.calculateSupport(itemsetHm_P_1);
                        double term1 = (double)lk.getAbsoluteSupport() / (double)databaseSize;
                        lift = term1 / ((term2 = supportAsDouble / (double)databaseSize) * (term3 = (double)supportHm_P_1 / (double)databaseSize));
                        if (lift < this.minlift) continue;
                    }
                    this.saveRule(itemset_Lk_minus_hm_P_1, support, itemsetHm_P_1, supportHm_P_1, lk.getAbsoluteSupport(), conf, lift);
                    H1_for_recursion.add(itemsetHm_P_1);
                }
                this.apGenrules(k, 1, lk, H1_for_recursion);
            }
        }
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTimeStamp = System.currentTimeMillis();
        return this.rules;
    }

    public void apGenrules(int k, int m, Itemset lk, List<int[]> Hm) throws IOException {
        if (k > m + 1) {
            ArrayList<int[]> Hm_plus_1_for_recursion = new ArrayList<int[]>();
            List<int[]> Hm_plus_1 = this.generateCandidateSizeK(Hm);
            for (int[] hm_P_1 : Hm_plus_1) {
                int[] itemset_Lk_minus_hm_P_1 = ArraysAlgos.cloneItemSetMinusAnItemset(lk.getItems(), hm_P_1);
                int support = this.calculateSupport(itemset_Lk_minus_hm_P_1);
                double supportAsDouble = support;
                double conf = (double)lk.getAbsoluteSupport() / supportAsDouble;
                if (conf < this.minconf || Double.isInfinite(conf)) continue;
                double lift = 0.0;
                int supportHm_P_1 = 0;
                if (this.usingLift) {
                    double term2;
                    supportHm_P_1 = this.calculateSupport(hm_P_1);
                    double term1 = (double)lk.getAbsoluteSupport() / (double)this.databaseSize;
                    lift = term1 / ((term2 = supportAsDouble / (double)this.databaseSize) * ((double)supportHm_P_1 / (double)this.databaseSize));
                    if (lift < this.minlift) continue;
                }
                this.saveRule(itemset_Lk_minus_hm_P_1, support, hm_P_1, supportHm_P_1, lk.getAbsoluteSupport(), conf, lift);
                if (k == m + 1) continue;
                Hm_plus_1_for_recursion.add(hm_P_1);
            }
            this.apGenrules(k, m + 1, lk, Hm_plus_1_for_recursion);
        }
    }

    public int calculateSupport(int[] itemset2) {
        return this.cfiTree.calculateSupport(itemset2);
    }
}

