/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.fhsar;

import ca.pfv.spmf.algorithms.associationrules.fhsar.Rule;
import ca.pfv.spmf.algorithms.associationrules.fhsar.Transaction;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;

public class AlgoFHSAR {
    int tidcount = 0;
    long startTimestamp = 0L;
    long endTimeStamp = 0L;
    private int minSuppRelative;

    public void runAlgorithm(String input, String inputSAR, String output, double minsup, double minconf) throws IOException {
        String line;
        this.startTimestamp = System.currentTimeMillis();
        ArrayList<Rule> sensitiveRules = new ArrayList<Rule>();
        ArrayList<Rule> checkRules = new ArrayList<Rule>();
        ArrayList<HashSet<Integer>> transactions = new ArrayList<HashSet<Integer>>();
        PriorityQueue<Transaction> pwt = new PriorityQueue<Transaction>();
        this.readSensitiveRulesIntoMemory(inputSAR, sensitiveRules);
        BufferedReader reader = new BufferedReader(new FileReader(input));
        this.tidcount = 0;
        while ((line = reader.readLine()) != null) {
            int n;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            HashSet<Integer> transaction = new HashSet<Integer>(lineSplited.length);
            for (n = 0; n < lineSplited.length; ++n) {
                int item = Integer.parseInt(lineSplited[n]);
                transaction.add(item);
            }
            n = 0;
            ArrayList<Rule> rulesContained = new ArrayList<Rule>();
            block2: for (Rule rule : sensitiveRules) {
                HashSet<Integer> matchLeft = new HashSet<Integer>();
                Iterator<Integer> matchRight = new HashSet();
                for (int i = 0; i < lineSplited.length; ++i) {
                    int item = Integer.parseInt(lineSplited[i]);
                    if (matchLeft.size() != rule.leftSide.size() && rule.leftSide.contains(item)) {
                        matchLeft.add(item);
                        if (matchLeft.size() == rule.leftSide.size()) {
                            ++rule.leftSideCount;
                        }
                    } else if (matchRight.size() != rule.rightSide.size() && rule.rightSide.contains(item)) {
                        matchRight.add(item);
                    }
                    if (matchLeft.size() != rule.leftSide.size() || matchRight.size() != rule.rightSide.size()) continue;
                    ++rule.count;
                    rulesContained.add(rule);
                    n = 1;
                    continue block2;
                }
            }
            if (n != 0) {
                HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
                for (Rule rule2 : rulesContained) {
                    Integer count;
                    for (Integer item : rule2.leftSide) {
                        count = (Integer)mapItemCount.get(item);
                        if (count == null) {
                            count = 0;
                        }
                        mapItemCount.put(item, count + 1);
                    }
                    for (Integer item : rule2.rightSide) {
                        count = (Integer)mapItemCount.get(item);
                        if (count == null) {
                            count = 0;
                        }
                        mapItemCount.put(item, count + 1);
                    }
                }
                Map map = mapItemCount.entrySet().stream().sorted((o1, o2) -> ((Integer)o2.getValue()).compareTo((Integer)o1.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
                Set<Integer> setItemRank = map.keySet();
                int mic = -1;
                int maxItem = -1;
                for (Map.Entry entry : mapItemCount.entrySet()) {
                    if ((Integer)entry.getValue() <= mic) continue;
                    maxItem = (Integer)entry.getKey();
                    mic = (Integer)entry.getValue();
                }
                double wi = (double)mic / Math.pow(2.0, (double)transaction.size() - 1.0);
                pwt.add(new Transaction(transaction, wi, maxItem, setItemRank));
            }
            ++this.tidcount;
            transactions.add(transaction);
        }
        reader.close();
        this.minSuppRelative = (int)Math.ceil(minsup * (double)this.tidcount);
        while (!sensitiveRules.isEmpty()) {
            double wi;
            boolean check = false;
            Transaction td = null;
            int n = 0;
            block9: while (!check) {
                Transaction tdd = (Transaction)pwt.poll();
                ArrayList<Rule> checkingRules = new ArrayList<Rule>();
                for (Rule checkRule : checkRules) {
                    if (tdd.items.containsAll(checkRule.leftSide) && tdd.items.containsAll(checkRule.rightSide)) continue;
                    checkingRules.add(checkRule);
                }
                for (Integer selectedItem : tdd.setItemRank) {
                    int dem = 0;
                    for (Rule checkingRule : checkingRules) {
                        if (checkingRule.leftSide.contains(selectedItem)) break;
                        ++dem;
                    }
                    if (dem != checkingRules.size()) continue;
                    check = true;
                    n = selectedItem;
                    td = tdd;
                    continue block9;
                }
            }
            HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
            boolean atLeastOneRule = false;
            for (Rule rule : sensitiveRules) {
                Integer count;
                if (!td.items.containsAll(rule.leftSide) || !td.items.containsAll(rule.rightSide)) continue;
                if (rule.leftSide.contains(n)) {
                    --rule.count;
                    --rule.leftSideCount;
                    continue;
                }
                if (rule.rightSide.contains(n)) {
                    --rule.count;
                    continue;
                }
                atLeastOneRule = true;
                for (Integer item : rule.leftSide) {
                    count = (Integer)mapItemCount.get(item);
                    if (count == null) {
                        count = 0;
                    }
                    mapItemCount.put(item, count + 1);
                }
                for (Integer item : rule.rightSide) {
                    count = (Integer)mapItemCount.get(item);
                    if (count == null) {
                        count = 0;
                    }
                    mapItemCount.put(item, count + 1);
                }
            }
            td.items.remove(n);
            Iterator iterator = sensitiveRules.iterator();
            while (iterator.hasNext()) {
                Rule rule;
                rule = (Rule)iterator.next();
                if (rule.count >= this.minSuppRelative && !((double)rule.count / (double)rule.leftSideCount < minconf)) continue;
                if (rule.count >= this.minSuppRelative) {
                    checkRules.add(rule);
                }
                iterator.remove();
            }
            if (!atLeastOneRule) continue;
            Map itemCount = mapItemCount.entrySet().stream().sorted((o1, o2) -> ((Integer)o2.getValue()).compareTo((Integer)o1.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
            Set newsetItemRank = itemCount.keySet();
            int mic = -1;
            int newMaxItem = -1;
            for (Map.Entry entry : mapItemCount.entrySet()) {
                if ((Integer)entry.getValue() <= mic) continue;
                newMaxItem = (Integer)entry.getKey();
                mic = (Integer)entry.getValue();
            }
            td.wi = wi = (double)mic / Math.pow(2.0, (double)td.items.size() - 1.0);
            td.maxItem = newMaxItem;
            td.setItemRank = newsetItemRank;
            pwt.add(td);
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        for (Set set : transactions) {
            ArrayList sorted = new ArrayList(set);
            Collections.sort(sorted);
            for (int i = 0; i < sorted.size(); ++i) {
                if (i > 0) {
                    writer.write(" " + sorted.get(i));
                    continue;
                }
                writer.write("" + sorted.get(i));
            }
            writer.newLine();
        }
        writer.close();
        this.endTimeStamp = System.currentTimeMillis();
    }

    private void readSensitiveRulesIntoMemory(String inputSAR, List<Rule> rules) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(inputSAR));
        while ((line = reader.readLine()) != null) {
            String[] lineSplited = line.split("==> ");
            String[] leftStrings = lineSplited[0].split(" ");
            String[] rightStrings = lineSplited[1].split(" ");
            Rule rule = new Rule();
            for (String string : leftStrings) {
                rule.leftSide.add(Integer.parseInt(string));
            }
            for (String string : rightStrings) {
                if (string.length() > 0 && string.charAt(0) == '#') break;
                rule.rightSide.add(Integer.parseInt(string));
            }
            rules.add(rule);
        }
        reader.close();
    }

    public void printStats() {
        System.out.println("=============  FSHAR 2.36 - STATS =============");
        System.out.println(" Transactions count from original database : " + this.tidcount);
        System.out.println(" minsup : " + this.minSuppRelative + " transactions");
        System.out.println(" Total time ~ " + (this.endTimeStamp - this.startTimestamp) + " ms");
        System.out.println("============================================");
    }
}

