/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.gcd;

import ca.pfv.spmf.algorithms.associationrules.gcd.Primes;
import ca.pfv.spmf.algorithms.associationrules.gcd.Transaction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DatTransformer {
    private Integer[] transRules;
    private List<Integer[]> inputFile = new ArrayList<Integer[]>();
    private Map<Integer, List<Transaction>> transactionSets = new TreeMap<Integer, List<Transaction>>();
    private double freqThreshold;
    private Integer freqThresholdPrime;
    private int rows = 0;

    public void cleanUP() {
        this.transRules = null;
        this.inputFile.clear();
        for (List<Transaction> set : this.transactionSets.values()) {
            set.clear();
        }
        this.transactionSets.clear();
    }

    public DatTransformer(List<String> inputLines, double freqThreshold) throws IOException, ClassNotFoundException {
        this.freqThreshold = freqThreshold;
        this.read(inputLines);
        this.transform();
    }

    public int getRowsCount() {
        return this.rows;
    }

    public double getFreqThreshold() {
        return this.freqThreshold;
    }

    public Integer[] primes2originals(List<Integer> primeFactors) {
        Integer[] translated = new Integer[primeFactors.size()];
        List<Integer> transRulesList = Arrays.asList(this.transRules);
        for (int i = 0; i < primeFactors.size(); ++i) {
            translated[i] = transRulesList.indexOf(primeFactors.get(i));
        }
        return translated;
    }

    private void transform() throws IOException, ClassNotFoundException {
        for (Object[] objectArray : this.inputFile) {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.transRules[(Integer)objectArray[i]];
            }
            Arrays.sort(objectArray);
            Object primeSet_key = objectArray[0];
            if ((Integer)primeSet_key > this.freqThresholdPrime) continue;
            List<Transaction> list = this.transactionSets.get(primeSet_key);
            if (list == null) {
                list = new ArrayList<Transaction>();
                this.transactionSets.put((Integer)primeSet_key, list);
            }
            list.add(new Transaction((Integer[])objectArray));
        }
        this.removeRepeatedTransactions();
        System.gc();
    }

    private void removeRepeatedTransactions() {
        HashMap<Integer, List<Transaction>> nonObsoleteTransactionSets = new HashMap<Integer, List<Transaction>>();
        for (Map.Entry<Integer, List<Transaction>> entry : this.transactionSets.entrySet()) {
            Integer prime = entry.getKey();
            List<Transaction> set = entry.getValue();
            Collections.sort(set);
            int setSize = set.size();
            for (int i = setSize - 1; i > 0; --i) {
                Transaction lastTransaction;
                Transaction transaction = set.get(i);
                if (!transaction.equals(lastTransaction = set.get(i - 1))) continue;
                int newFrequency = transaction.getFrequency() + 1;
                lastTransaction.setFrequency(newFrequency);
                transaction.makeObsolete();
            }
            ArrayList<Transaction> nonObsoleteTransactionSet = new ArrayList<Transaction>();
            for (int i = 0; i < setSize; ++i) {
                Transaction transaction = set.get(i);
                if (transaction.isObsolete()) continue;
                nonObsoleteTransactionSet.add(transaction);
            }
            if (nonObsoleteTransactionSet.isEmpty()) continue;
            nonObsoleteTransactionSets.put(prime, nonObsoleteTransactionSet);
        }
        this.transactionSets = nonObsoleteTransactionSets;
    }

    private void read(List<String> inputLines) throws IOException {
        HashMap<Integer, Integer> freqs = new HashMap<Integer, Integer>();
        int cols = 0;
        for (String line : inputLines) {
            ++this.rows;
            String[] tokens = line.split("\\s+");
            Integer[] numbers = new Integer[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i];
                int number = Integer.parseInt(token);
                numbers[i] = number;
                Integer freq = (Integer)freqs.get(number);
                if (freq != null) {
                    int newValue = freq + 1;
                    freqs.put(number, newValue);
                } else {
                    freqs.put(number, 1);
                }
                if (number <= cols) continue;
                cols = number;
            }
            this.inputFile.add(numbers);
        }
        this.freqThreshold *= (double)this.rows;
        System.out.println("Minimum item frequency is: " + (int)this.freqThreshold);
        Set entries = freqs.entrySet();
        ArrayList sortedEntries = new ArrayList(entries);
        Collections.sort(sortedEntries, new Comparator<Map.Entry<Integer, Integer>>(){

            @Override
            public int compare(Map.Entry<Integer, Integer> o1, Map.Entry<Integer, Integer> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        this.transRules = new Integer[cols + 1];
        Primes primes = Primes.getInstance();
        for (Map.Entry entry : sortedEntries) {
            this.transRules[((Integer)entry.getKey()).intValue()] = primes.getNextPrime();
            if (this.freqThresholdPrime != null || !((double)((Integer)entry.getValue()).intValue() < this.freqThreshold)) continue;
            this.freqThresholdPrime = this.transRules[(Integer)entry.getKey()];
        }
        if (this.freqThresholdPrime == null) {
            this.freqThresholdPrime = Integer.MAX_VALUE;
        }
        Transaction.setMaxPrimeThreshold(this.freqThresholdPrime);
    }

    public Map<Integer, List<Transaction>> getTransactionSets() {
        return this.transactionSets;
    }
}

