/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.gcd;

import ca.pfv.spmf.algorithms.associationrules.gcd.AssociationRule;
import ca.pfv.spmf.algorithms.associationrules.gcd.DatTransformer;
import ca.pfv.spmf.algorithms.associationrules.gcd.GCDAssociator;
import ca.pfv.spmf.algorithms.associationrules.gcd.MyBigInteger;
import ca.pfv.spmf.algorithms.associationrules.gcd.Transaction;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class GCDAssociationRules {
    private static final DateFormat FORMATTER = new SimpleDateFormat("[hh:mm:ss a]");
    private DatTransformer datTransformer;
    private double inputConfThreshold;
    private double inputFreqThreshold;
    private String outputFilePath;
    private String inputFilePath;
    private int itemsetCount;
    private long startTimestamp;
    private long endTimestamp;

    public GCDAssociationRules(String inputFilePath, String outputFilePath, double inputFreqThreshold, double inputConfThreshold, int combinationsElementsLimit) {
        this.inputFilePath = inputFilePath;
        this.outputFilePath = outputFilePath;
        this.inputFreqThreshold = inputFreqThreshold;
        this.inputConfThreshold = inputConfThreshold;
        MyBigInteger.setCombinationsElementsLimit(combinationsElementsLimit);
    }

    public void runAlgorithm() throws Exception {
        MemoryLogger.getInstance().reset();
        this.startTimestamp = Calendar.getInstance().getTimeInMillis();
        List<String> inputLines = this.extractInputFileLines();
        this.datTransformer = new DatTransformer(inputLines, this.inputFreqThreshold);
        Map<Integer, List<Transaction>> transactionSets = this.datTransformer.getTransactionSets();
        LinkedList<Thread> allThreads = new LinkedList<Thread>();
        System.out.println("Extracting GCDs");
        for (Integer primeNumber : new TreeSet<Integer>(transactionSets.keySet())) {
            allThreads.addAll(new GCDAssociator(primeNumber, transactionSets).generateGCDTables());
        }
        this.executeThreads(allThreads);
        long gcdsExtractionTime = Calendar.getInstance().getTimeInMillis() - this.startTimestamp;
        System.out.println("GCDs extraction time (ms): " + gcdsExtractionTime);
        System.out.println("Extracting support values");
        allThreads.addAll(new GCDAssociator(0, transactionSets).getSupportCalculationThreads());
        this.executeThreads(allThreads);
        long supportCalculationTime = Calendar.getInstance().getTimeInMillis() - this.startTimestamp - gcdsExtractionTime;
        System.out.println("Support values time (ms): " + supportCalculationTime);
        new GCDAssociator(0, transactionSets).cleanUp();
        System.out.println("Extracting confidence values");
        allThreads.addAll(new GCDAssociator(0, null).getConfidenceCalculationThreads(this.datTransformer.getFreqThreshold(), this.inputConfThreshold));
        this.executeThreads(allThreads);
        System.out.println("Confidence values time (ms): " + (Calendar.getInstance().getTimeInMillis() - this.startTimestamp - gcdsExtractionTime - supportCalculationTime));
        List<AssociationRule> associationRules = GCDAssociator.getAssociationRules();
        AssociationRule.setTotalTransactionsCount(this.datTransformer.getRowsCount());
        Collections.sort(associationRules, new Comparator<AssociationRule>(){

            @Override
            public int compare(AssociationRule o1, AssociationRule o2) {
                return o2.getSupport().compareTo(o1.getSupport());
            }
        });
        List<String> lines = this.constructCSVLines(associationRules);
        this.writeCSV(lines);
        GCDAssociator.getResults().clear();
        associationRules.clear();
        lines.clear();
        this.datTransformer.cleanUP();
        this.endTimestamp = Calendar.getInstance().getTimeInMillis();
        System.gc();
        MemoryLogger.getInstance().checkMemory();
    }

    private List<String> constructCSVLines(List<AssociationRule> associationRules) {
        LinkedList<String> lines = new LinkedList<String>();
        for (AssociationRule rule : associationRules) {
            StringBuilder line = new StringBuilder();
            line.append(this.getOriginalFactorsForGCD(rule.getAntecedent())).append(" ==> ");
            line.append(this.getOriginalFactorsForGCD(rule.getConsequent())).append(" #SUP: ");
            line.append(rule.getSupport()).append(" #CONF: ");
            line.append(rule.getConfidence());
            lines.add(line.toString());
        }
        this.itemsetCount = lines.size();
        return lines;
    }

    private List<String> extractInputFileLines() throws FileNotFoundException, IOException {
        String line;
        ArrayList<String> inputLines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(new File(this.inputFilePath)));
        while ((line = reader.readLine()) != null) {
            inputLines.add(line);
        }
        reader.close();
        return inputLines;
    }

    private String getOriginalFactorsForGCD(MyBigInteger gcd) {
        Object[] originalFactors = this.datTransformer.primes2originals(gcd.getFactors());
        Arrays.sort(originalFactors);
        return Arrays.toString(originalFactors).replaceAll("[\\[\\]]", "").replaceAll(",", "");
    }

    private void writeCSV(List<String> lines) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.outputFilePath)));
        for (String line : lines) {
            writer.append(line).append("\n");
        }
        writer.close();
    }

    private void executeThreads(LinkedList<Thread> threads) throws InterruptedException {
        int i;
        int threadsCount = threads.size();
        if (threadsCount == 0) {
            return;
        }
        int max_running_threads = Runtime.getRuntime().availableProcessors();
        Thread[] activeThreads = new Thread[max_running_threads];
        for (int i2 = 0; i2 < activeThreads.length; ++i2) {
            activeThreads[i2] = threads.poll();
            if (activeThreads[i2] == null) break;
            activeThreads[i2].start();
        }
        int progress = this.calculateProgress(threads, threadsCount, max_running_threads);
        this.printProgress(progress);
        Thread nextThread = threads.poll();
        long time = Calendar.getInstance().getTimeInMillis();
        while (nextThread != null) {
            i = 0;
            while (activeThreads[i].isAlive()) {
                i = (i + 1) % activeThreads.length;
            }
            activeThreads[i] = nextThread;
            activeThreads[i].start();
            progress = this.calculateProgress(threads, threadsCount, max_running_threads);
            nextThread = threads.poll();
            if (Calendar.getInstance().getTimeInMillis() - time <= 5000L) continue;
            this.printProgress(progress);
            time = Calendar.getInstance().getTimeInMillis();
        }
        i = 0;
        while (i < activeThreads.length) {
            if (activeThreads[i] != null && !activeThreads[i].isAlive()) {
                int doneCounter = 0;
                for (int j = 0; j < activeThreads.length; ++j) {
                    if (activeThreads[j] != null && !activeThreads[j].isAlive()) {
                        activeThreads[j] = null;
                    }
                    if (activeThreads[j] != null) continue;
                    ++doneCounter;
                }
                progress = Math.round(100.0f * ((float)(threadsCount - max_running_threads + doneCounter) / (float)threadsCount));
                this.printProgress(progress);
                if (doneCounter == max_running_threads) break;
            }
            i = (i + 1) % activeThreads.length;
        }
        this.printProgress(100);
        MemoryLogger.getInstance().checkMemory();
    }

    private int calculateProgress(LinkedList<Thread> threads, int threadsCount, int max_running_threads) {
        return Math.round(100.0f * ((float)(threadsCount - threads.size() - max_running_threads) / (float)threadsCount));
    }

    private void printProgress(int progress) {
        String time = FORMATTER.format(Calendar.getInstance().getTime());
        System.out.println(time + " " + progress + "%");
    }

    public void printStats() {
        System.out.println("=========  GCD Association Rules - STATS =========");
        System.out.println(" Pattern count : " + this.itemsetCount);
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }

    public int getPatternCount() {
        return this.itemsetCount;
    }
}

