/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.gcd;

import ca.pfv.spmf.algorithms.associationrules.gcd.AssociationRule;
import ca.pfv.spmf.algorithms.associationrules.gcd.GCDInfo;
import ca.pfv.spmf.algorithms.associationrules.gcd.MyBigInteger;
import ca.pfv.spmf.algorithms.associationrules.gcd.Transaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GCDAssociator {
    private Integer primeNumber;
    private static Map<Integer, List<Transaction>> transactionSets;
    private static Set<GCDInfo> results;
    private static List<AssociationRule> associationRules;
    private static List<GCDInfo> sortedResultsByFreqs;
    private static double inputConfThreshold;

    public GCDAssociator(Integer primeNumber, Map<Integer, List<Transaction>> transactionSets) {
        this.primeNumber = primeNumber;
        GCDAssociator.transactionSets = transactionSets;
        MyBigInteger.setResultsSet(results);
    }

    public static Set<GCDInfo> getResults() {
        return results;
    }

    public static List<AssociationRule> getAssociationRules() {
        return associationRules;
    }

    public LinkedList<SupportCalcThread> getSupportCalculationThreads() {
        LinkedList<SupportCalcThread> threads = new LinkedList<SupportCalcThread>();
        for (GCDInfo gcd : results) {
            threads.add(new SupportCalcThread(gcd));
        }
        return threads;
    }

    private static List<GCDInfo> getGCDsSortedByFreq_DESC() {
        ArrayList<GCDInfo> sortedEntries = new ArrayList<GCDInfo>(results);
        Collections.sort(sortedEntries, new Comparator<GCDInfo>(){

            @Override
            public int compare(GCDInfo o1, GCDInfo o2) {
                return o2.getFrequency().compareTo(o1.getFrequency());
            }
        });
        return sortedEntries;
    }

    public LinkedList<GCDExtractorThread> generateGCDTables() {
        List<Transaction> firstTransactionSet = transactionSets.get(this.primeNumber);
        LinkedList<GCDExtractorThread> threads = new LinkedList<GCDExtractorThread>();
        for (int i = 0; i < firstTransactionSet.size(); ++i) {
            threads.add(new GCDExtractorThread(i, firstTransactionSet));
        }
        return threads;
    }

    private static synchronized void harvestAssociationRule(AssociationRule rule) {
        associationRules.add(rule);
    }

    public List<ConfidenceCalcThread> getConfidenceCalculationThreads(double freqThreshold, double inputConfThreshold) {
        GCDAssociator.inputConfThreshold = inputConfThreshold;
        LinkedList<ConfidenceCalcThread> threads = new LinkedList<ConfidenceCalcThread>();
        for (int i = 0; i < sortedResultsByFreqs.size(); ++i) {
            if (!((double)sortedResultsByFreqs.get(i).getFrequency().intValue() >= freqThreshold)) continue;
            threads.add(new ConfidenceCalcThread(i));
        }
        return threads;
    }

    public void cleanUp() {
        transactionSets.clear();
        sortedResultsByFreqs = GCDAssociator.getGCDsSortedByFreq_DESC();
        System.gc();
    }

    static {
        results = new HashSet<GCDInfo>();
        associationRules = new LinkedList<AssociationRule>();
    }

    public final class SupportCalcThread
    extends Thread {
        private final GCDInfo gcdInfo;

        private SupportCalcThread(GCDInfo gcdInfo) {
            this.gcdInfo = gcdInfo;
        }

        @Override
        public void run() {
            MyBigInteger gcd = this.gcdInfo.getGCD();
            List<Integer> gcdFactors = gcd.getFactors();
            Integer biggestGCDFactor = gcdFactors.get(gcdFactors.size() - 1);
            for (Map.Entry entry : transactionSets.entrySet()) {
                if (biggestGCDFactor < (Integer)entry.getKey()) continue;
                List setTransactions = (List)entry.getValue();
                for (Transaction transaction : setTransactions) {
                    if (!transaction.getMultiplication().isDivisibleBy(gcd)) continue;
                    this.gcdInfo.incrementFrequency(transaction.getFrequency());
                }
            }
        }
    }

    public final class GCDExtractorThread
    extends Thread {
        private final int i;
        private final List<Transaction> firstTransactionSet;

        private GCDExtractorThread(int i, List<Transaction> firstTransactionSet) {
            this.i = i;
            this.firstTransactionSet = firstTransactionSet;
        }

        @Override
        public void run() {
            Transaction firstTransaction = this.firstTransactionSet.get(this.i);
            if (firstTransaction.getFrequency() > 1) {
                MyBigInteger.harvestGCD(firstTransaction.getMultiplication());
            }
            for (int j = this.i + 1; j < this.firstTransactionSet.size(); ++j) {
                Transaction secondTransaction = this.firstTransactionSet.get(j);
                secondTransaction.calcAndHarvestGCDs(firstTransaction);
            }
            List<Integer> firstTransactionItems = firstTransaction.getItems();
            Integer lastItemInFirstTransaction = firstTransactionItems.get(firstTransactionItems.size() - 1);
            for (Map.Entry entry : transactionSets.entrySet()) {
                Integer key = (Integer)entry.getKey();
                if (key <= this.i) continue;
                if (key > lastItemInFirstTransaction) break;
                List secondTransactionSet = (List)entry.getValue();
                this.calcGCDBetweenTransactionAndSet(firstTransaction, secondTransactionSet);
            }
        }

        private void calcGCDBetweenTransactionAndSet(Transaction firstTransaction, List<Transaction> secondTransactionSet) {
            for (Transaction secondTransaction : secondTransactionSet) {
                secondTransaction.calcAndHarvestGCDs(firstTransaction);
            }
        }
    }

    public final class ConfidenceCalcThread
    extends Thread {
        private int gcdIndex;

        private ConfidenceCalcThread(int gcdIndex) {
            this.gcdIndex = gcdIndex;
        }

        @Override
        public void run() {
            GCDInfo bigGCDInfo = (GCDInfo)sortedResultsByFreqs.get(this.gcdIndex);
            MyBigInteger bigGCD = bigGCDInfo.getGCD();
            double support = bigGCDInfo.getFrequency().intValue();
            for (int j = sortedResultsByFreqs.size() - 1; j >= 0; --j) {
                if (j == this.gcdIndex) continue;
                GCDInfo smallGCDInfo = (GCDInfo)sortedResultsByFreqs.get(j);
                MyBigInteger smallGCD = smallGCDInfo.getGCD();
                double confidence = support / (double)smallGCDInfo.getFrequency().intValue();
                if (confidence < inputConfThreshold) break;
                MyBigInteger subGCD = bigGCD.divide(smallGCD);
                if (subGCD == null || !results.contains(subGCD)) continue;
                GCDAssociator.harvestAssociationRule(new AssociationRule(smallGCD, subGCD, support, confidence));
            }
        }
    }
}

