/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.gcd;

import ca.pfv.spmf.algorithms.associationrules.gcd.MyBigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Transaction
implements Comparable<Transaction> {
    private ArrayList<Integer> items = new ArrayList();
    private MyBigInteger multiplication = MyBigInteger.constructMyBigInteger_One();
    private int frequency = 1;
    private static int maxPrimeThreshold;

    public Transaction(Integer[] items) {
        Arrays.sort((Object[])items);
        for (int i = 0; i < items.length; ++i) {
            Integer item = items[i];
            if (i > 0 && items[i] == items[i - 1]) continue;
            if (item > maxPrimeThreshold) break;
            this.multiplication.multiply(item);
            this.items.add(item);
        }
    }

    public static void setMaxPrimeThreshold(int maxPrimeThreshold) {
        Transaction.maxPrimeThreshold = maxPrimeThreshold;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void makeObsolete() {
        this.frequency = 0;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public boolean isObsolete() {
        return this.frequency == 0;
    }

    public void calcAndHarvestGCDs(Transaction other) {
        this.multiplication.calcAndHarvestGCDs(other.multiplication);
    }

    @Override
    public int compareTo(Transaction o) {
        return this.getMultiplication().compareTo(o.getMultiplication());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Transaction)) {
            return false;
        }
        return ((Transaction)obj).getMultiplication().equals(this.getMultiplication());
    }

    public String toString() {
        return this.items + "{" + this.frequency + "}";
    }

    public List<Integer> getItems() {
        return this.items;
    }

    public MyBigInteger getMultiplication() {
        return this.multiplication;
    }
}

