/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.clustering.clusterreader;

import ca.pfv.spmf.patterns.cluster.Cluster;
import ca.pfv.spmf.patterns.cluster.DoubleArray;
import ca.pfv.spmf.patterns.cluster.DoubleArrayInstance;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class AlgoClusterReader {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    boolean DEBUG_MODE = false;
    int clusterCount = 0;
    int dimensionCount = 0;
    private List<String> attributeNames = null;

    public List<Cluster> runAlgorithm(String input) throws IOException {
        String thisLine;
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        this.attributeNames = new ArrayList<String>();
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        BufferedReader myInput = null;
        boolean instanceHaveAName = false;
        if (this.DEBUG_MODE) {
            System.out.println(System.lineSeparator() + "======= READING THE INPUT FILE =======");
        }
        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
        while ((thisLine = myInput.readLine()) != null) {
            String token;
            int i;
            boolean newInstance;
            int indexValue;
            Cluster cluster;
            double[] values;
            DoubleArray instance;
            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%') continue;
            if (thisLine.charAt(0) == '@') {
                if (!thisLine.startsWith("@ATTRIBUTEDEF=")) continue;
                String attributeName = thisLine.substring(14, thisLine.length());
                this.attributeNames.add(attributeName);
                continue;
            }
            if (this.DEBUG_MODE) {
                System.out.println(System.lineSeparator() + "--- Reading cluster #" + (clusters.size() + 1) + " ---");
            }
            thisLine = thisLine.substring(1, thisLine.length()).replace('[', ' ');
            String[] tokens = thisLine.split(" ");
            if (clusters.size() == 0) {
                for (String token2 : tokens) {
                    boolean lastDimension = false;
                    if (token2.charAt(token2.length() - 1) == ']') {
                        token2 = token2.substring(0, token2.length() - 1);
                        lastDimension = true;
                    }
                    double value = 0.0;
                    boolean isNumber = true;
                    try {
                        value = Double.parseDouble(token2);
                    }
                    catch (NumberFormatException nfe) {
                        isNumber = false;
                        instanceHaveAName = true;
                    }
                    if (isNumber) {
                        ++this.dimensionCount;
                    }
                    if (lastDimension) break;
                }
                if (this.DEBUG_MODE) {
                    System.out.println("Number of dimensions: " + this.dimensionCount);
                    System.out.println("Instances have names?: " + instanceHaveAName);
                }
            }
            if (instanceHaveAName) {
                instance = null;
                values = null;
                cluster = new Cluster();
                indexValue = 0;
                newInstance = true;
                for (i = 0; i < tokens.length; ++i) {
                    if (newInstance) {
                        String instanceName = tokens[i];
                        values = new double[this.dimensionCount];
                        instance = new DoubleArrayInstance(values, instanceName);
                        indexValue = 0;
                        newInstance = false;
                        continue;
                    }
                    token = tokens[i];
                    if (token.charAt(token.length() - 1) == ']') {
                        newInstance = true;
                        token = token.substring(0, token.length() - 1);
                        cluster.addVector(instance);
                    }
                    double value = 0.0;
                    try {
                        value = Double.parseDouble(token);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                        throw new RuntimeException("Error in input file - parseDouble");
                    }
                    values[indexValue++] = value;
                }
                clusters.add(cluster);
                continue;
            }
            instance = null;
            values = null;
            cluster = new Cluster();
            indexValue = 0;
            newInstance = true;
            for (i = 0; i < tokens.length; ++i) {
                if (newInstance) {
                    values = new double[this.dimensionCount];
                    instance = new DoubleArray(values);
                    indexValue = 0;
                    newInstance = false;
                }
                if ((token = tokens[i]).charAt(token.length() - 1) == ']') {
                    newInstance = true;
                    token = token.substring(0, token.length() - 1);
                    cluster.addVector(instance);
                }
                double value = 0.0;
                try {
                    value = Double.parseDouble(token);
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                    throw new RuntimeException("Error in input file - parseDouble");
                }
                values[indexValue++] = value;
            }
            clusters.add(cluster);
        }
        if (this.attributeNames.size() == 0 && clusters.size() > 0) {
            int dimensionCount = ((Cluster)clusters.get((int)0)).getVectors().get((int)0).data.length;
            for (int i = 0; i < dimensionCount; ++i) {
                this.attributeNames.add("Attribute" + i);
            }
        }
        this.clusterCount = clusters.size();
        myInput.close();
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return clusters;
    }

    public void printStats() {
        System.out.println("======= READ CLUSTERS TO MEMORY v2.09 - STATS =======");
        System.out.println(" Number of clusters processed: " + this.clusterCount);
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("=====================================================================");
    }

    public int getDimensionCount() {
        return this.dimensionCount;
    }

    public List<String> getAttributeNames() {
        return this.attributeNames;
    }
}

