/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.clustering.distanceFunctions;

import ca.pfv.spmf.algorithms.clustering.distanceFunctions.DistanceCorrelation;
import ca.pfv.spmf.algorithms.clustering.distanceFunctions.DistanceCosine;
import ca.pfv.spmf.algorithms.clustering.distanceFunctions.DistanceEuclidian;
import ca.pfv.spmf.algorithms.clustering.distanceFunctions.DistanceJaccard;
import ca.pfv.spmf.algorithms.clustering.distanceFunctions.DistanceManathan;
import ca.pfv.spmf.patterns.cluster.DoubleArray;

public abstract class DistanceFunction {
    public abstract double calculateDistance(DoubleArray var1, DoubleArray var2);

    public abstract String getName();

    public static DistanceFunction getDistanceFunctionByName(String name) {
        if (DistanceCorrelation.NAME.equals(name)) {
            return new DistanceCorrelation();
        }
        if (DistanceCosine.NAME.equals(name)) {
            return new DistanceCosine();
        }
        if (DistanceEuclidian.NAME.equals(name)) {
            return new DistanceEuclidian();
        }
        if (DistanceManathan.NAME.equals(name)) {
            return new DistanceManathan();
        }
        if (DistanceJaccard.NAME.equals(name)) {
            return new DistanceJaccard();
        }
        return null;
    }
}

