/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.clustering.distanceFunctions;

import ca.pfv.spmf.algorithms.clustering.distanceFunctions.DistanceCosine;
import ca.pfv.spmf.algorithms.clustering.distanceFunctions.DistanceFunction;
import ca.pfv.spmf.patterns.cluster.DoubleArray;

public class DistanceJaccard
extends DistanceFunction {
    static String NAME = "jaccard";

    @Override
    public double calculateDistance(DoubleArray vector1, DoubleArray vector2) {
        double count11 = 0.0;
        double count10or01or11 = 0.0;
        for (int i = 0; i < vector1.data.length; ++i) {
            if (vector1.data[i] == 0.0 && vector2.data[i] == 0.0) continue;
            if (vector1.data[i] == 1.0 && vector2.data[i] == 1.0) {
                count11 += 1.0;
            }
            count10or01or11 += 1.0;
        }
        return count11 / count10or01or11;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static void main(String[] args) {
        DoubleArray array1 = new DoubleArray(new double[]{0.0, 1.0, 0.0, 1.0});
        DoubleArray array2 = new DoubleArray(new double[]{1.0, 0.0, 0.0, 1.0});
        System.out.println(new DistanceJaccard().calculateDistance(array1, array2));
        DoubleArray array4 = new DoubleArray(new double[]{1.0, 0.0});
        DoubleArray array3 = new DoubleArray(new double[]{1.0, 0.0});
        System.out.println(new DistanceCosine().calculateDistance(array3, array4));
    }
}

