/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.clustering.hierarchical_clustering;

import ca.pfv.spmf.algorithms.clustering.distanceFunctions.DistanceFunction;
import ca.pfv.spmf.algorithms.clustering.instancereader.AlgoInstanceFileReader;
import ca.pfv.spmf.patterns.cluster.Cluster;
import ca.pfv.spmf.patterns.cluster.ClusterWithMean;
import ca.pfv.spmf.patterns.cluster.ClustersEvaluation;
import ca.pfv.spmf.patterns.cluster.DoubleArray;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AlgoHierarchicalClustering {
    private double maxDistance = 0.0;
    List<ClusterWithMean> clusters = null;
    private long startTimestamp;
    private long endTimestamp;
    private long iterationCount;
    private DistanceFunction distanceFunction = null;
    private List<String> attributeNames = null;

    public List<ClusterWithMean> runAlgorithm(String inputFile, double maxDistance, DistanceFunction distanceFunction, String separator) throws NumberFormatException, IOException {
        this.startTimestamp = System.currentTimeMillis();
        this.maxDistance = maxDistance;
        this.distanceFunction = distanceFunction;
        this.clusters = new ArrayList<ClusterWithMean>();
        AlgoInstanceFileReader reader = new AlgoInstanceFileReader();
        List<DoubleArray> instances = reader.runAlgorithm(inputFile, separator);
        int dimensionCount = reader.getAttributeNames().size();
        this.attributeNames = reader.getAttributeNames();
        for (DoubleArray instance : instances) {
            ClusterWithMean cluster = new ClusterWithMean(dimensionCount);
            cluster.addVector(instance);
            cluster.setMean(instance.clone());
            this.clusters.add(cluster);
        }
        boolean changed = false;
        do {
            changed = this.mergeTheClosestCluster();
            MemoryLogger.getInstance().checkMemory();
        } while (changed);
        this.endTimestamp = System.currentTimeMillis();
        return this.clusters;
    }

    private boolean mergeTheClosestCluster() {
        ClusterWithMean clusterToMerge1 = null;
        Cluster clusterToMerge2 = null;
        double minClusterDistance = 2.147483647E9;
        for (int i = 0; i < this.clusters.size(); ++i) {
            for (int j = i + 1; j < this.clusters.size(); ++j) {
                double distance = this.distanceFunction.calculateDistance(this.clusters.get(i).getmean(), this.clusters.get(j).getmean());
                if (!(distance < minClusterDistance) || !(distance <= this.maxDistance)) continue;
                minClusterDistance = distance;
                clusterToMerge1 = this.clusters.get(i);
                clusterToMerge2 = this.clusters.get(j);
            }
        }
        if (clusterToMerge1 == null) {
            return false;
        }
        for (DoubleArray vector : clusterToMerge2.getVectors()) {
            clusterToMerge1.addVector(vector);
        }
        clusterToMerge1.recomputeClusterMean();
        this.clusters.remove(clusterToMerge2);
        ++this.iterationCount;
        return true;
    }

    public void saveToFile(String output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        for (String attributeName : this.attributeNames) {
            writer.write("@ATTRIBUTEDEF=" + attributeName);
            writer.newLine();
        }
        for (int i = 0; i < this.clusters.size(); ++i) {
            if (this.clusters.get(i).getVectors().size() < 1) continue;
            writer.write(this.clusters.get(i).toString());
            if (i >= this.clusters.size() - 1) continue;
            writer.newLine();
        }
        writer.close();
    }

    public void printStatistics() {
        System.out.println("========== HIERARCHICAL CLUSTERING SPMF 2.09 - STATS ============");
        System.out.println(" Distance function: " + this.distanceFunction.getName());
        System.out.println(" Total time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" SSE (Sum of Squared Errors) (lower is better) : " + ClustersEvaluation.calculateSSE(this.clusters, this.distanceFunction));
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory() + " mb ");
        System.out.println(" Iteration count: " + this.iterationCount);
        System.out.println("=====================================");
    }
}

