/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.clustering.instancereader;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.patterns.cluster.DoubleArray;
import ca.pfv.spmf.patterns.cluster.DoubleArrayInstance;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class AlgoInstanceFileReader {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    boolean DEBUG_MODE = false;
    int instanceCount = 0;
    private List<DoubleArray> instances;
    private List<String> attributeNames = null;

    public List<DoubleArray> runAlgorithm(String input, String separator) throws IOException {
        String thisLine;
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        this.instances = new ArrayList<DoubleArray>();
        this.attributeNames = new ArrayList<String>();
        BufferedReader myInput = null;
        this.instanceCount = 0;
        if (this.DEBUG_MODE) {
            System.out.println(System.lineSeparator() + "======= READING THE INPUT FILE =======");
        }
        String currentInstanceName = null;
        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
        while ((thisLine = myInput.readLine()) != null) {
            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%') continue;
            if (thisLine.charAt(0) == '@') {
                if (thisLine.startsWith("@NAME=")) {
                    currentInstanceName = thisLine.substring(6, thisLine.length());
                }
                if (!thisLine.startsWith("@ATTRIBUTEDEF=")) continue;
                String attributeName = thisLine.substring(14, thisLine.length());
                this.attributeNames.add(attributeName);
                continue;
            }
            if (this.DEBUG_MODE) {
                System.out.println(System.lineSeparator() + "--- Reading instance #" + (this.instanceCount + 1) + " ---");
            }
            String[] tokens = thisLine.split(separator);
            double[] dataPoints = ArraysAlgos.convertStringArrayToDoubleArray(tokens);
            String nameToUse = currentInstanceName == null ? "Series " + this.instanceCount : currentInstanceName;
            currentInstanceName = null;
            this.instances.add(new DoubleArrayInstance(dataPoints, nameToUse));
            ++this.instanceCount;
        }
        if (this.attributeNames.size() == 0 && this.instances.size() > 0) {
            int dimensionCount = this.instances.get((int)0).data.length;
            for (int i = 0; i < dimensionCount; ++i) {
                this.attributeNames.add("Attribute" + i);
            }
        }
        this.instanceCount = this.instances.size();
        myInput.close();
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return this.instances;
    }

    public void printStats() {
        System.out.println("======= READ INSTANCES TO MEMORY v2.09 - STATS =======");
        System.out.println(" Number of instances processed: " + this.instanceCount);
        System.out.println(" Number of attributes: " + this.attributeNames.size());
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("=====================================================================");
    }

    public List<String> getAttributeNames() {
        return this.attributeNames;
    }
}

