/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.clustering.kmeans;

import ca.pfv.spmf.algorithms.clustering.distanceFunctions.DistanceFunction;
import ca.pfv.spmf.algorithms.clustering.kmeans.AlgoKMeans;
import ca.pfv.spmf.patterns.cluster.ClusterWithMean;
import ca.pfv.spmf.patterns.cluster.ClustersEvaluation;
import ca.pfv.spmf.patterns.cluster.DoubleArray;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AlgoBisectingKMeans
extends AlgoKMeans {
    int iter = -1;

    public List<ClusterWithMean> runAlgorithm(String inputFile, int k, DistanceFunction distanceFunction, int iter, String separator) throws NumberFormatException, IOException {
        this.iter = iter;
        return this.runAlgorithm(inputFile, k, distanceFunction, separator);
    }

    @Override
    void applyAlgorithm(int k, DistanceFunction distanceFunction, List<DoubleArray> vectors, double minValue, double maxValue, int vectorsSize) {
        this.clusters = new ArrayList();
        List<DoubleArray> currentVectors = vectors;
        while (true) {
            List<ClusterWithMean> bestClustersUntilNow = null;
            double smallestSSE = Double.MAX_VALUE;
            for (int i = 0; i < this.iter; ++i) {
                List<ClusterWithMean> newClusters = this.applyKMeans(2, distanceFunction, currentVectors, minValue, maxValue, vectorsSize);
                double sse = ClustersEvaluation.calculateSSE(newClusters, distanceFunction);
                if (!(sse < smallestSSE)) continue;
                bestClustersUntilNow = newClusters;
                smallestSSE = sse;
            }
            this.clusters.addAll(bestClustersUntilNow);
            if (this.clusters.size() == k) break;
            int biggestClusterSize = -1;
            int biggestClusterIndex = -1;
            for (int i = 0; i < this.clusters.size(); ++i) {
                ClusterWithMean cluster = (ClusterWithMean)this.clusters.get(i);
                if (cluster.getVectors().size() <= biggestClusterSize) continue;
                biggestClusterIndex = i;
                biggestClusterSize = cluster.getVectors().size();
                currentVectors = cluster.getVectors();
            }
            this.clusters.remove(biggestClusterIndex);
        }
    }

    @Override
    public void printStatistics() {
        System.out.println("========== BISECTING KMEANS - SPMF 2.09 - STATS ============");
        System.out.println(" Distance function: " + this.distanceFunction.getName());
        System.out.println(" Total time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" SSE (Sum of Squared Errors) (lower is better) : " + ClustersEvaluation.calculateSSE(this.clusters, this.distanceFunction));
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory() + " mb ");
        System.out.println("=====================================");
    }
}

