/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.clustering.kmeans;

import ca.pfv.spmf.algorithms.clustering.distanceFunctions.DistanceFunction;
import ca.pfv.spmf.algorithms.clustering.instancereader.AlgoInstanceFileReader;
import ca.pfv.spmf.patterns.cluster.ClusterWithMean;
import ca.pfv.spmf.patterns.cluster.ClustersEvaluation;
import ca.pfv.spmf.patterns.cluster.DoubleArray;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class AlgoKMeans {
    protected List<ClusterWithMean> clusters = null;
    protected static final Random random = new Random(System.currentTimeMillis());
    protected long startTimestamp;
    protected long endTimestamp;
    long iterationCount;
    protected DistanceFunction distanceFunction = null;
    private List<String> attributeNames = null;

    public List<ClusterWithMean> runAlgorithm(String inputFile, int k, DistanceFunction distanceFunction, String separator) throws NumberFormatException, IOException {
        this.startTimestamp = System.currentTimeMillis();
        this.iterationCount = 0L;
        this.distanceFunction = distanceFunction;
        double minValue = 2.147483647E9;
        double maxValue = 0.0;
        AlgoInstanceFileReader reader = new AlgoInstanceFileReader();
        List<DoubleArray> instances = reader.runAlgorithm(inputFile, separator);
        int dimensionCount = reader.getAttributeNames().size();
        this.attributeNames = reader.getAttributeNames();
        for (DoubleArray instance : instances) {
            for (double value : instance.data) {
                if (value < minValue) {
                    minValue = value;
                }
                if (!(value > maxValue)) continue;
                maxValue = value;
            }
        }
        int vectorsSize = instances.get((int)0).data.length;
        if (k == 1) {
            this.clusters = new ArrayList<ClusterWithMean>();
            ClusterWithMean cluster = new ClusterWithMean(vectorsSize);
            Object object = instances.iterator();
            while (object.hasNext()) {
                DoubleArray vector = (DoubleArray)object.next();
                cluster.addVector(vector);
            }
            cluster.setMean(new DoubleArray(new double[vectorsSize]));
            cluster.recomputeClusterMean();
            this.clusters.add(cluster);
            MemoryLogger.getInstance().checkMemory();
            this.endTimestamp = System.currentTimeMillis();
            return this.clusters;
        }
        if (instances.size() == 1) {
            this.clusters = new ArrayList<ClusterWithMean>();
            DoubleArray vector = instances.get(0);
            ClusterWithMean cluster = new ClusterWithMean(vectorsSize);
            cluster.addVector(vector);
            cluster.recomputeClusterMean();
            cluster.setMean(new DoubleArray(new double[vectorsSize]));
            this.clusters.add(cluster);
            MemoryLogger.getInstance().checkMemory();
            this.endTimestamp = System.currentTimeMillis();
            return this.clusters;
        }
        if (k > instances.size()) {
            k = instances.size();
        }
        this.applyAlgorithm(k, distanceFunction, instances, minValue, maxValue, vectorsSize);
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return this.clusters;
    }

    void applyAlgorithm(int k, DistanceFunction distanceFunction, List<DoubleArray> vectors, double minValue, double maxValue, int vectorsSize) {
        this.clusters = this.applyKMeans(k, distanceFunction, vectors, minValue, maxValue, vectorsSize);
    }

    List<ClusterWithMean> applyKMeans(int k, DistanceFunction distanceFunction, List<DoubleArray> vectors, double minValue, double maxValue, int vectorsSize) {
        ClusterWithMean cluster;
        ArrayList<ClusterWithMean> newClusters = new ArrayList<ClusterWithMean>();
        if (vectors.size() == 1) {
            DoubleArray vector = vectors.get(0);
            ClusterWithMean cluster2 = new ClusterWithMean(vectorsSize);
            cluster2.addVector(vector);
            newClusters.add(cluster2);
            return newClusters;
        }
        for (int i = 0; i < k; ++i) {
            DoubleArray meanVector = this.generateRandomVector(minValue, maxValue, vectorsSize);
            cluster = new ClusterWithMean(vectorsSize);
            cluster.setMean(meanVector);
            newClusters.add(cluster);
        }
        block1: while (true) {
            ++this.iterationCount;
            boolean changed = false;
            for (DoubleArray vector : vectors) {
                ClusterWithMean nearestCluster = null;
                ClusterWithMean containingCluster = null;
                double distanceToNearestCluster = Double.MAX_VALUE;
                for (ClusterWithMean cluster3 : newClusters) {
                    double distance = distanceFunction.calculateDistance(cluster3.getmean(), vector);
                    if (distance < distanceToNearestCluster) {
                        nearestCluster = cluster3;
                        distanceToNearestCluster = distance;
                    }
                    if (!cluster3.contains(vector)) continue;
                    containingCluster = cluster3;
                }
                if (containingCluster == nearestCluster) continue;
                if (containingCluster != null) {
                    containingCluster.remove(vector);
                }
                nearestCluster.addVector(vector);
                changed = true;
            }
            MemoryLogger.getInstance().checkMemory();
            if (!changed) break;
            Iterator<DoubleArray> iterator = newClusters.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block1;
                cluster = (ClusterWithMean)((Object)iterator.next());
                cluster.recomputeClusterMean();
            }
            break;
        }
        return newClusters;
    }

    DoubleArray generateRandomVector(double minValue, double maxValue, int vectorsSize) {
        double[] vector = new double[vectorsSize];
        for (int i = 0; i < vectorsSize; ++i) {
            vector[i] = random.nextDouble() * (maxValue - minValue) + minValue;
        }
        return new DoubleArray(vector);
    }

    public void saveToFile(String output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        for (String attributeName : this.attributeNames) {
            writer.write("@ATTRIBUTEDEF=" + attributeName);
            writer.newLine();
        }
        for (int i = 0; i < this.clusters.size(); ++i) {
            if (this.clusters.get(i).getVectors().size() < 1) continue;
            writer.write(this.clusters.get(i).toString());
            if (i >= this.clusters.size() - 1) continue;
            writer.newLine();
        }
        writer.close();
    }

    public void printStatistics() {
        System.out.println("========== KMEANS - SPMF 2.09 - STATS ============");
        System.out.println(" Distance function: " + this.distanceFunction.getName());
        System.out.println(" Total time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" SSE (Sum of Squared Errors) (lower is better) : " + ClustersEvaluation.calculateSSE(this.clusters, this.distanceFunction));
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory() + " mb ");
        System.out.println(" Iteration count: " + this.iterationCount);
        System.out.println("=====================================");
    }
}

