/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.clustering.optics;

import ca.pfv.spmf.algorithms.clustering.distanceFunctions.DistanceEuclidian;
import ca.pfv.spmf.algorithms.clustering.distanceFunctions.DistanceFunction;
import ca.pfv.spmf.algorithms.clustering.optics.DoubleArrayOPTICS;
import ca.pfv.spmf.datastructures.kdtree.KDTree;
import ca.pfv.spmf.datastructures.kdtree.KNNPoint;
import ca.pfv.spmf.patterns.cluster.Cluster;
import ca.pfv.spmf.patterns.cluster.DoubleArray;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;

public class AlgoOPTICS {
    protected long timeExtractClusterOrdering;
    DistanceFunction distanceFunction = new DistanceEuclidian();
    KDTree kdtree;
    List<DoubleArrayOPTICS> clusterOrdering = null;
    List<Cluster> clusters = null;
    List<KNNPoint> neighboorsBuffer1 = new ArrayList<KNNPoint>();
    List<KNNPoint> neighboorsBuffer2 = new ArrayList<KNNPoint>();
    private List<String> attributeNames = null;

    public List<DoubleArrayOPTICS> computerClusterOrdering(String inputFile, int minPts, double epsilon, String separator) throws NumberFormatException, IOException {
        String line;
        this.timeExtractClusterOrdering = 0L;
        long startTimestampClusterOrdering = System.currentTimeMillis();
        ArrayList<DoubleArray> points = new ArrayList<DoubleArray>();
        this.attributeNames = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(inputFile));
        String currentInstanceName = null;
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%') continue;
            if (line.charAt(0) == '@') {
                if (line.startsWith("@NAME=")) {
                    currentInstanceName = line.substring(6, line.length());
                }
                if (!line.startsWith("@ATTRIBUTEDEF=")) continue;
                String attributeName = line.substring(14, line.length());
                this.attributeNames.add(attributeName);
                continue;
            }
            String nameToUse = currentInstanceName == null ? "Instance" + points.size() : currentInstanceName;
            currentInstanceName = null;
            line = line.trim();
            String[] lineSplited = line.split(separator);
            double[] vector = new double[lineSplited.length];
            for (int i = 0; i < lineSplited.length; ++i) {
                double value;
                vector[i] = value = Double.parseDouble(lineSplited[i]);
            }
            points.add(new DoubleArrayOPTICS(vector, nameToUse));
        }
        reader.close();
        if (this.attributeNames.size() == 0 && points.size() > 0) {
            int dimensionCount = ((DoubleArray)points.get((int)0)).data.length;
            for (int i = 0; i < dimensionCount; ++i) {
                this.attributeNames.add("Attribute" + i);
            }
        }
        this.kdtree = new KDTree();
        this.kdtree.buildtree(points);
        this.clusterOrdering = new ArrayList<DoubleArrayOPTICS>();
        for (DoubleArray point : points) {
            DoubleArrayOPTICS pointDBS = (DoubleArrayOPTICS)point;
            if (pointDBS.visited) continue;
            this.expandClusterOrder(pointDBS, this.clusterOrdering, epsilon, minPts);
        }
        MemoryLogger.getInstance().checkMemory();
        this.timeExtractClusterOrdering = System.currentTimeMillis() - startTimestampClusterOrdering;
        this.neighboorsBuffer1.clear();
        this.neighboorsBuffer2.clear();
        this.kdtree = null;
        return this.clusterOrdering;
    }

    private void expandClusterOrder(DoubleArrayOPTICS pointDBS, List<DoubleArrayOPTICS> orderedFile, double epsilon, int minPts) {
        this.neighboorsBuffer1.clear();
        this.kdtree.pointsWithinRadiusOfWithDistance(pointDBS, epsilon, this.neighboorsBuffer1);
        pointDBS.visited = true;
        pointDBS.reachabilityDistance = Double.POSITIVE_INFINITY;
        pointDBS.setCoreDistance(this.neighboorsBuffer1, epsilon, minPts);
        orderedFile.add(pointDBS);
        if (pointDBS.core_distance != Double.POSITIVE_INFINITY) {
            PriorityQueue<DoubleArrayOPTICS> orderSeeds = new PriorityQueue<DoubleArrayOPTICS>();
            this.update(this.neighboorsBuffer1, pointDBS, orderSeeds, minPts, epsilon);
            while (!orderSeeds.isEmpty()) {
                DoubleArrayOPTICS currentObject = orderSeeds.poll();
                this.neighboorsBuffer2.clear();
                this.kdtree.pointsWithinRadiusOfWithDistance(currentObject, epsilon, this.neighboorsBuffer2);
                currentObject.visited = true;
                currentObject.setCoreDistance(this.neighboorsBuffer2, epsilon, minPts);
                orderedFile.add(currentObject);
                if (currentObject.core_distance == Double.POSITIVE_INFINITY) continue;
                this.update(this.neighboorsBuffer2, currentObject, orderSeeds, minPts, epsilon);
            }
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void update(List<KNNPoint> neighbors, DoubleArrayOPTICS centerObject, PriorityQueue<DoubleArrayOPTICS> orderSeeds, int minPts, double epsilon) {
        double cDist = centerObject.core_distance;
        for (KNNPoint object : neighbors) {
            DoubleArrayOPTICS objectOP = (DoubleArrayOPTICS)object.values;
            if (objectOP.visited) continue;
            double newRDistance = Math.max(cDist, this.distanceFunction.calculateDistance(objectOP, centerObject));
            if (objectOP.reachabilityDistance == Double.POSITIVE_INFINITY) {
                objectOP.reachabilityDistance = newRDistance;
                orderSeeds.add(objectOP);
                continue;
            }
            if (!(newRDistance < objectOP.reachabilityDistance)) continue;
            objectOP.reachabilityDistance = newRDistance;
            orderSeeds.remove(objectOP);
            orderSeeds.add(objectOP);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    public List<Cluster> extractDBScan(int minPts, double epsilonPrime) throws IOException {
        this.clusters = new ArrayList<Cluster>();
        Cluster currentCluster = new Cluster();
        for (DoubleArrayOPTICS objectOP : this.clusterOrdering) {
            if (objectOP.reachabilityDistance > epsilonPrime) {
                if (!(objectOP.core_distance <= epsilonPrime)) continue;
                if (currentCluster.getVectors().size() > 0) {
                    this.clusters.add(currentCluster);
                }
                currentCluster = new Cluster();
                currentCluster.addVector(objectOP);
                continue;
            }
            currentCluster.addVector(objectOP);
        }
        if (currentCluster.getVectors().size() > 0) {
            this.clusters.add(currentCluster);
        }
        return this.clusters;
    }

    public void saveToFile(String output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        for (String attributeName : this.attributeNames) {
            writer.write("@ATTRIBUTEDEF=" + attributeName);
            writer.newLine();
        }
        for (int i = 0; i < this.clusters.size(); ++i) {
            if (this.clusters.get(i).getVectors().size() < 1) continue;
            writer.write(this.clusters.get(i).toString());
            if (i >= this.clusters.size() - 1) continue;
            writer.newLine();
        }
        writer.close();
    }

    public void saveClusterOrderingToFile(String output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        for (DoubleArrayOPTICS arrayOP : this.clusterOrdering) {
            writer.write(arrayOP.toString() + " " + arrayOP.reachabilityDistance);
            writer.newLine();
        }
        writer.close();
    }

    public void printStatistics() {
        System.out.println("========== OPTICS  SPMF 2.09 - STATS ============");
        System.out.println(" Time ExtractClusterOrdering() ~: " + this.timeExtractClusterOrdering + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory() + " mb ");
        if (this.clusters != null) {
            System.out.println(" Number of clusters: " + this.clusters.size());
        }
        System.out.println("=====================================");
    }
}

