/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.emma;

import ca.pfv.spmf.algorithms.episodes.emma.EncodingTable;
import ca.pfv.spmf.algorithms.episodes.emma.Episode;
import ca.pfv.spmf.algorithms.episodes.emma.FrequentEpisodes;
import ca.pfv.spmf.algorithms.episodes.emma.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoEMMA {
    private long startTimestamp;
    private long endTimestamp;
    private int candidateCount = 0;
    private boolean selfIncrement;
    private FrequentEpisodes freEpisodes = null;
    private List<int[]> indexDB;
    private List<Itemset> frequentItemsets = null;
    private EncodingTable encodingTable = null;
    private int minSupport;
    private int maxWindow;

    public FrequentEpisodes runAlgorithm(String input, String output, int minSupport, int maxWindow, boolean selfIncrement) throws IOException {
        MemoryLogger.getInstance().reset();
        this.minSupport = minSupport;
        this.maxWindow = maxWindow;
        this.selfIncrement = selfIncrement;
        this.startTimestamp = System.currentTimeMillis();
        this.indexDB = new ArrayList<int[]>();
        this.frequentItemsets = new ArrayList<Itemset>();
        Set<Integer> frequentItemsName = this.scanDatabaseToDetermineFrequentItems(input);
        int frequentItemsCount = frequentItemsName.size();
        this.scanDatabaseAgainToDetermineIndexDB(input, frequentItemsName);
        frequentItemsName = null;
        for (int i = 0; i < frequentItemsCount; ++i) {
            this.fimajoin(this.frequentItemsets.get(i), 1);
        }
        this.encodingTable = new EncodingTable();
        this.freEpisodes = new FrequentEpisodes();
        for (Itemset itemset2 : this.frequentItemsets) {
            ArrayList<int[]> events = new ArrayList<int[]>();
            events.add(itemset2.getName());
            Episode episode = new Episode(events, itemset2.getSupport());
            this.freEpisodes.addFrequentEpisode(episode, 1);
            ++this.candidateCount;
            ArrayList<int[]> boundlist = new ArrayList<int[]>();
            for (int location : itemset2.getLocationList()) {
                int[] bound = new int[]{this.indexDB.get(location)[1], this.indexDB.get(location)[1]};
                boundlist.add(bound);
            }
            this.encodingTable.addEpisodeAndBoundlist(episode, boundlist);
        }
        this.indexDB = null;
        this.frequentItemsets = null;
        for (int i = 0; i < this.encodingTable.getTableLength(); ++i) {
            this.serialJoins(this.encodingTable.getEpisodebyID(i), this.encodingTable.getBoundlistByID(i), 1);
        }
        this.encodingTable = null;
        this.endTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().checkMemory();
        if (output != null) {
            this.freEpisodes.saveToFile(output);
        }
        return this.freEpisodes;
    }

    private void serialJoins(Episode alpha, List<int[]> alphaBoundlist, int levelNum) {
        for (int j = 0; j < this.encodingTable.getTableLength(); ++j) {
            List<int[]> tempBoundlist = this.temporalJoin(alphaBoundlist, this.encodingTable.getBoundlistByID(j));
            if (tempBoundlist.size() < this.minSupport) continue;
            Episode beta = alpha.sExtension(this.encodingTable.getEpisodeNameByID(j), tempBoundlist.size());
            this.freEpisodes.addFrequentEpisode(beta, levelNum + 1);
            this.serialJoins(beta, tempBoundlist, levelNum + 1);
        }
    }

    private List<int[]> temporalJoin(List<int[]> alphaBoundlist, List<int[]> fjBoundlist) {
        ++this.candidateCount;
        ArrayList<int[]> tempBoundlist = new ArrayList<int[]>();
        int i = 0;
        int j = 0;
        while (i < alphaBoundlist.size() && j < fjBoundlist.size()) {
            if (fjBoundlist.get(j)[1] <= alphaBoundlist.get(i)[1]) {
                ++j;
                continue;
            }
            if (fjBoundlist.get(j)[1] - alphaBoundlist.get(i)[0] >= this.maxWindow) {
                ++i;
                continue;
            }
            tempBoundlist.add(new int[]{alphaBoundlist.get(i)[0], fjBoundlist.get(j)[1]});
            ++i;
        }
        return tempBoundlist;
    }

    private void fimajoin(Itemset itemset2, int itemsetLength) {
        HashMap<Integer, List<Integer>> mapCurrentItemsLocationList = new HashMap<Integer, List<Integer>>();
        List<Integer> lfi = this.generatePListAndObtainFrequentItems(itemset2.getLocationList(), mapCurrentItemsLocationList);
        for (int lf_j : lfi) {
            int[] newFreItemset = new int[itemsetLength + 1];
            System.arraycopy(itemset2.getName(), 0, newFreItemset, 0, itemsetLength);
            newFreItemset[itemsetLength] = lf_j;
            Itemset newItemset = new Itemset(newFreItemset, (List)mapCurrentItemsLocationList.get(lf_j));
            this.frequentItemsets.add(newItemset);
            this.fimajoin(newItemset, itemsetLength + 1);
        }
    }

    private List<Integer> generatePListAndObtainFrequentItems(List<Integer> locationList, Map<Integer, List<Integer>> mapCurrentItemsLocationList) {
        ArrayList<Integer> frequentItems = new ArrayList<Integer>();
        HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
        for (int i = 0; i < locationList.size(); ++i) {
            int index = locationList.get(i);
            int currentTid = this.indexDB.get(index)[1];
            ++index;
            while (index < this.indexDB.size() && this.indexDB.get(index)[1] == currentTid) {
                int itemName = this.indexDB.get(index)[0];
                Integer support = (Integer)mapItemCount.get(itemName);
                List<Integer> currentItemLocationList = mapCurrentItemsLocationList.get(itemName);
                if (support == null) {
                    mapItemCount.put(itemName, 1);
                    currentItemLocationList = new ArrayList<Integer>();
                    currentItemLocationList.add(index);
                    mapCurrentItemsLocationList.put(itemName, currentItemLocationList);
                } else {
                    mapItemCount.put(itemName, support + 1);
                    currentItemLocationList.add(index);
                    mapCurrentItemsLocationList.put(itemName, currentItemLocationList);
                }
                ++index;
            }
        }
        for (Map.Entry entry : mapItemCount.entrySet()) {
            if ((Integer)entry.getValue() >= this.minSupport) {
                frequentItems.add((Integer)entry.getKey());
                continue;
            }
            mapCurrentItemsLocationList.remove(entry.getKey());
        }
        return frequentItems;
    }

    private void scanDatabaseAgainToDetermineIndexDB(String input, Set<Integer> frequentItemsName) throws IOException {
        Object[] lineSplited;
        String line;
        int currentTID;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        HashMap mapItemLocationList = new HashMap();
        int index = 0;
        if (this.selfIncrement) {
            currentTID = 0;
            while ((line = reader.readLine()) != null) {
                ++currentTID;
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                lineSplited = line.split(" ");
                Arrays.sort(lineSplited);
                for (Object itemString : lineSplited) {
                    Integer itemName = Integer.parseInt((String)itemString);
                    if (!frequentItemsName.contains(itemName)) continue;
                    ArrayList<Integer> locationList = (ArrayList<Integer>)mapItemLocationList.get(itemName);
                    if (locationList == null) {
                        locationList = new ArrayList<Integer>();
                        locationList.add(index);
                        mapItemLocationList.put(itemName, locationList);
                        this.indexDB.add(new int[]{itemName, currentTID});
                        ++index;
                        continue;
                    }
                    if ((Integer)locationList.get(locationList.size() - 1) == index) continue;
                    locationList.add(index);
                    mapItemLocationList.put(itemName, locationList);
                    this.indexDB.add(new int[]{itemName, currentTID});
                    ++index;
                }
            }
        } else {
            currentTID = 1;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                lineSplited = line.split("\\|");
                String[] lineItems = ((String)lineSplited[0]).split(" ");
                currentTID = Integer.parseInt((String)lineSplited[1]);
                for (String itemString : lineItems) {
                    Integer itemName = Integer.parseInt(itemString);
                    if (!frequentItemsName.contains(itemName)) continue;
                    ArrayList<Integer> locationList = (ArrayList<Integer>)mapItemLocationList.get(itemName);
                    if (locationList == null) {
                        locationList = new ArrayList<Integer>();
                        locationList.add(index);
                        mapItemLocationList.put(itemName, locationList);
                        this.indexDB.add(new int[]{itemName, currentTID});
                        ++index;
                        continue;
                    }
                    if ((Integer)locationList.get(locationList.size() - 1) == index) continue;
                    locationList.add(index);
                    mapItemLocationList.put(itemName, locationList);
                    this.indexDB.add(new int[]{itemName, currentTID});
                    ++index;
                }
            }
        }
        for (int i = 0; i < this.frequentItemsets.size(); ++i) {
            int itemName = this.frequentItemsets.get(i).getName()[0];
            this.frequentItemsets.get(i).setLocationList((List)mapItemLocationList.get(itemName));
        }
    }

    private Set<Integer> scanDatabaseToDetermineFrequentItems(String input) throws IOException {
        String[] lineSplited;
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
        if (this.selfIncrement) {
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                for (String itemString : lineSplited = line.split(" ")) {
                    Integer itemName = Integer.parseInt(itemString);
                    Integer itemSupport = (Integer)mapItemCount.get(itemName);
                    if (itemSupport == null) {
                        mapItemCount.put(itemName, 1);
                        continue;
                    }
                    mapItemCount.put(itemName, itemSupport + 1);
                }
            }
        } else {
            while ((line = reader.readLine()) != null) {
                String[] lineItems;
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                lineSplited = line.split("\\|");
                for (String itemString : lineItems = lineSplited[0].split(" ")) {
                    Integer itemName = Integer.parseInt(itemString);
                    Integer itemSupport = (Integer)mapItemCount.get(itemName);
                    if (itemSupport == null) {
                        mapItemCount.put(itemName, 1);
                        continue;
                    }
                    mapItemCount.put(itemName, itemSupport + 1);
                }
            }
        }
        HashSet<Integer> frequentItemsName = new HashSet<Integer>();
        for (Map.Entry entry : mapItemCount.entrySet()) {
            if ((Integer)entry.getValue() < this.minSupport) continue;
            Itemset item = new Itemset(new int[]{(Integer)entry.getKey()});
            this.frequentItemsets.add(item);
            frequentItemsName.add((Integer)entry.getKey());
        }
        reader.close();
        return frequentItemsName;
    }

    public void printStats() {
        System.out.println("=============  EMMA(head episode) - STATS =============");
        System.out.println(" Candidates count : " + this.candidateCount);
        System.out.println(" The algorithm stopped at size : " + this.freEpisodes.getTotalLevelNum());
        System.out.println(" Frequent itemsets count : " + this.freEpisodes.getFrequentEpisodesCount());
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println(" Total time ~ : " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }
}

