/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.emma;

import ca.pfv.spmf.algorithms.episodes.emma.Episode;
import ca.pfv.spmf.algorithms.episodes.emma.EpisodeAndBoundList;
import ca.pfv.spmf.algorithms.episodes.emma.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

public class AlgoTKE {
    private long startTimestamp;
    private long endTimestamp;
    private int candidateCount = 0;
    private boolean selfIncrement;
    PriorityQueue<Itemset> kItemsets;
    PriorityQueue<Itemset> candidatesFIMA;
    PriorityQueue<Episode> kEpisodes;
    PriorityQueue<EpisodeAndBoundList> candidates;
    private List<int[]> indexDB;
    private List<Itemset> frequentItemsets = null;
    private List<EpisodeAndBoundList> encodingTable = null;
    private int minSupport;
    private int maxWindow;
    private int k;
    private boolean ONE_ITEM_INCREASE = true;
    private boolean FIMA_INCREASE = true;
    private boolean DYNAMIC_SEARCH_FIMA = true;
    private boolean DYNAMIC_SEARCH_SERIAL = true;
    private boolean DEBUG_MODE = false;
    PriorityQueue<Integer> itemSupportQueue = null;

    public PriorityQueue<Episode> runAlgorithm(String input, String output, int k, int maxWindow, boolean selfIncrement) throws IOException {
        Object boundlist;
        MemoryLogger.getInstance().reset();
        this.minSupport = 1;
        this.k = k;
        this.maxWindow = maxWindow;
        this.selfIncrement = selfIncrement;
        this.kEpisodes = new PriorityQueue();
        if (this.FIMA_INCREASE || this.ONE_ITEM_INCREASE) {
            this.itemSupportQueue = new PriorityQueue();
        }
        this.candidates = new PriorityQueue(Comparator.reverseOrder());
        this.kItemsets = new PriorityQueue();
        if (this.DYNAMIC_SEARCH_FIMA) {
            this.candidatesFIMA = new PriorityQueue(Comparator.reverseOrder());
        }
        this.frequentItemsets = new ArrayList<Itemset>();
        this.startTimestamp = System.currentTimeMillis();
        this.indexDB = new ArrayList<int[]>();
        Set<Integer> frequentItemsName = this.scanDatabaseToDetermineFrequentItems(input);
        int frequentItemsCount = frequentItemsName.size();
        this.scanDatabaseAgainToDetermineIndexDB(input, frequentItemsName);
        frequentItemsName = null;
        if (this.DEBUG_MODE) {
            // empty if block
        }
        if (this.DYNAMIC_SEARCH_FIMA) {
            Itemset pattern;
            for (Itemset itemset2 : this.frequentItemsets) {
                if (itemset2.getSupport() < this.minSupport) continue;
                this.registerAsFIMACandidate(itemset2);
                this.save(itemset2);
            }
            while (this.candidatesFIMA.size() > 0 && (pattern = this.candidatesFIMA.poll()).getSupport() >= this.minSupport) {
                this.fimajoinDynamic(pattern);
            }
            if (this.DEBUG_MODE) {
                System.out.println("=== AFTER FIMA JOIN ====");
                System.out.println("itemSuportQueue.size() : " + this.itemSupportQueue.size());
                System.out.println("minup = " + this.minSupport);
            }
            this.encodingTable = new ArrayList<EpisodeAndBoundList>();
            PriorityQueue<Itemset> sourceOfItemsets = this.kItemsets;
            for (Itemset itemset3 : sourceOfItemsets) {
                if (itemset3.getSupport() < this.minSupport) continue;
                ArrayList<int[]> events = new ArrayList<int[]>();
                events.add(itemset3.getName());
                Episode episode = new Episode(events, itemset3.getSupport());
                this.save(episode);
                ++this.candidateCount;
                boundlist = new ArrayList();
                for (int location : itemset3.getLocationList()) {
                    int[] bound = new int[]{this.indexDB.get(location)[1], this.indexDB.get(location)[1]};
                    boundlist.add(bound);
                }
                EpisodeAndBoundList episodeAndBound = new EpisodeAndBoundList(episode, (List<int[]>)boundlist);
                this.encodingTable.add(episodeAndBound);
            }
            this.candidatesFIMA = null;
            this.kItemsets = null;
        } else {
            for (int i = 0; i < frequentItemsCount; ++i) {
                Itemset itemset3 = this.frequentItemsets.get(i);
                if (itemset3.getSupport() < this.minSupport) continue;
                this.fimajoin(itemset3);
            }
            if (this.DEBUG_MODE) {
                System.out.println("=== AFTER FIMA JOIN ====");
                System.out.println("minup = " + this.minSupport);
            }
            this.encodingTable = new ArrayList<EpisodeAndBoundList>();
            for (Itemset itemset4 : this.frequentItemsets) {
                if (itemset4.getSupport() < this.minSupport) continue;
                ArrayList<int[]> events = new ArrayList<int[]>();
                events.add(itemset4.getName());
                Episode episode = new Episode(events, itemset4.getSupport());
                this.save(episode);
                ++this.candidateCount;
                ArrayList<int[]> boundlist2 = new ArrayList<int[]>();
                boundlist = itemset4.getLocationList().iterator();
                while (boundlist.hasNext()) {
                    int location = (Integer)boundlist.next();
                    int[] bound = new int[]{this.indexDB.get(location)[1], this.indexDB.get(location)[1]};
                    boundlist2.add(bound);
                }
                EpisodeAndBoundList episodeAndBound = new EpisodeAndBoundList(episode, boundlist2);
                this.encodingTable.add(episodeAndBound);
            }
        }
        this.indexDB = null;
        this.frequentItemsets = null;
        if (this.DYNAMIC_SEARCH_SERIAL) {
            for (int i = 0; i < this.encodingTable.size(); ++i) {
                this.serialJoins(this.encodingTable.get(i));
            }
            while (this.candidates.size() > 0) {
                EpisodeAndBoundList pattern = this.candidates.poll();
                if (pattern.episode.support >= this.minSupport) {
                    this.serialJoins(pattern);
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < this.encodingTable.size(); ++i) {
                this.serialJoinsNonDynamicSearch(this.encodingTable.get(i));
            }
        }
        this.encodingTable = null;
        this.endTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().checkMemory();
        if (output != null) {
            this.writeResultTofile(output);
        }
        if (this.DEBUG_MODE) {
            System.out.println("=== AFTER END ====");
            System.out.println(" minsup: " + this.minSupport);
        }
        return this.kEpisodes;
    }

    private void registerAsCandidate(EpisodeAndBoundList pattern) {
        this.candidates.add(pattern);
        MemoryLogger.getInstance().checkMemory();
    }

    private void registerAsFIMACandidate(Itemset pattern) {
        this.candidatesFIMA.add(pattern);
    }

    private void save(Episode pattern) {
        this.kEpisodes.add(pattern);
        if (this.kEpisodes.size() > this.k) {
            if (pattern.support > this.minSupport) {
                do {
                    this.kEpisodes.poll();
                } while (this.kEpisodes.size() > this.k);
            }
            this.minSupport = this.kEpisodes.peek().support;
        }
    }

    private void save(Itemset pattern) {
        this.kItemsets.add(pattern);
        if (this.kItemsets.size() > this.k) {
            if (pattern.getSupport() > this.minSupport) {
                do {
                    this.kItemsets.poll();
                } while (this.kItemsets.size() > this.k);
            }
            this.minSupport = this.kItemsets.peek().getSupport();
        }
    }

    private void saveToItemSupportQueue(Integer value) {
        this.itemSupportQueue.add(value);
        if (this.itemSupportQueue.size() > this.k) {
            if (value > this.minSupport) {
                do {
                    this.itemSupportQueue.poll();
                } while (this.itemSupportQueue.size() > this.k);
            }
            this.minSupport = this.itemSupportQueue.peek();
        }
    }

    private void serialJoins(EpisodeAndBoundList alphaWithList) {
        Episode alpha = alphaWithList.episode;
        List<int[]> alphaBoundlist = alphaWithList.boundlist;
        for (int j = 0; j < this.encodingTable.size(); ++j) {
            List<int[]> tempBoundlist;
            if (this.encodingTable.get((int)j).boundlist.size() < this.minSupport || (tempBoundlist = this.temporalJoin(alphaBoundlist, this.encodingTable.get((int)j).boundlist)).size() < this.minSupport) continue;
            Episode beta = alpha.sExtension(this.encodingTable.get((int)j).episode.events.get(0), tempBoundlist.size());
            this.save(beta);
            if (this.DEBUG_MODE) {
                System.out.println("=====");
                System.out.println(beta);
                for (int[] array : tempBoundlist) {
                    System.out.println(Arrays.toString(array));
                }
                System.out.println("=====");
            }
            EpisodeAndBoundList episodeWithList = new EpisodeAndBoundList(beta, tempBoundlist);
            this.registerAsCandidate(episodeWithList);
        }
    }

    private void serialJoinsNonDynamicSearch(EpisodeAndBoundList alphaWithList) {
        Episode alpha = alphaWithList.episode;
        List<int[]> alphaBoundlist = alphaWithList.boundlist;
        for (int j = 0; j < this.encodingTable.size(); ++j) {
            List<int[]> tempBoundlist;
            if (this.encodingTable.get((int)j).boundlist.size() < this.minSupport || (tempBoundlist = this.temporalJoin(alphaBoundlist, this.encodingTable.get((int)j).boundlist)).size() < this.minSupport) continue;
            Episode beta = alpha.sExtension(this.encodingTable.get((int)j).episode.events.get(0), tempBoundlist.size());
            this.save(beta);
            EpisodeAndBoundList episodeWithList = new EpisodeAndBoundList(beta, tempBoundlist);
            this.serialJoinsNonDynamicSearch(episodeWithList);
        }
    }

    private List<int[]> temporalJoin(List<int[]> alphaBoundlist, List<int[]> fjBoundlist) {
        ++this.candidateCount;
        ArrayList<int[]> tempBoundlist = new ArrayList<int[]>();
        int i = 0;
        int j = 0;
        while (i < alphaBoundlist.size() && j < fjBoundlist.size()) {
            if (fjBoundlist.get(j)[1] <= alphaBoundlist.get(i)[1]) {
                ++j;
                continue;
            }
            if (fjBoundlist.get(j)[1] - alphaBoundlist.get(i)[0] >= this.maxWindow) {
                ++i;
                continue;
            }
            tempBoundlist.add(new int[]{alphaBoundlist.get(i)[0], fjBoundlist.get(j)[1]});
            ++i;
        }
        return tempBoundlist;
    }

    private void fimajoin(Itemset itemset2) {
        HashMap<Integer, List<Integer>> mapCurrentItemsLocationList = new HashMap<Integer, List<Integer>>();
        List<Integer> lfi = this.generatePListAndObtainFrequentItems(itemset2.getLocationList(), mapCurrentItemsLocationList);
        for (int lf_j : lfi) {
            List locationList = (List)mapCurrentItemsLocationList.get(lf_j);
            int support = locationList.size();
            if (support < this.minSupport) continue;
            int itemsetLength = itemset2.getName().length;
            int[] newFreItemset = new int[itemsetLength + 1];
            System.arraycopy(itemset2.getName(), 0, newFreItemset, 0, itemsetLength);
            newFreItemset[itemsetLength] = lf_j;
            Itemset newItemset = new Itemset(newFreItemset, locationList);
            this.frequentItemsets.add(newItemset);
            this.fimajoin(newItemset);
        }
    }

    private void fimajoinDynamic(Itemset itemset2) {
        HashMap<Integer, List<Integer>> mapCurrentItemsLocationList = new HashMap<Integer, List<Integer>>();
        List<Integer> lfi = this.generatePListAndObtainFrequentItems(itemset2.getLocationList(), mapCurrentItemsLocationList);
        for (int lf_j : lfi) {
            List locationList = (List)mapCurrentItemsLocationList.get(lf_j);
            int support = locationList.size();
            if (support < this.minSupport) continue;
            int itemsetLength = itemset2.getName().length;
            int[] newFreItemset = new int[itemsetLength + 1];
            System.arraycopy(itemset2.getName(), 0, newFreItemset, 0, itemsetLength);
            newFreItemset[itemsetLength] = lf_j;
            Itemset newItemset = new Itemset(newFreItemset, locationList);
            this.registerAsFIMACandidate(newItemset);
            this.save(newItemset);
        }
    }

    private List<Integer> generatePListAndObtainFrequentItems(List<Integer> locationList, Map<Integer, List<Integer>> mapCurrentItemsLocationList) {
        ArrayList<Integer> frequentItems = new ArrayList<Integer>();
        HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
        for (int i = 0; i < locationList.size(); ++i) {
            int index = locationList.get(i);
            int currentTid = this.indexDB.get(index)[1];
            ++index;
            while (index < this.indexDB.size() && this.indexDB.get(index)[1] == currentTid) {
                int itemName = this.indexDB.get(index)[0];
                Integer support = (Integer)mapItemCount.get(itemName);
                List<Integer> currentItemLocationList = mapCurrentItemsLocationList.get(itemName);
                if (support == null) {
                    mapItemCount.put(itemName, 1);
                    currentItemLocationList = new ArrayList<Integer>();
                    currentItemLocationList.add(index);
                    mapCurrentItemsLocationList.put(itemName, currentItemLocationList);
                } else {
                    mapItemCount.put(itemName, support + 1);
                    currentItemLocationList.add(index);
                    mapCurrentItemsLocationList.put(itemName, currentItemLocationList);
                }
                ++index;
            }
        }
        for (Map.Entry entry : mapItemCount.entrySet()) {
            if ((Integer)entry.getValue() >= this.minSupport) {
                ++this.candidateCount;
                frequentItems.add((Integer)entry.getKey());
                if (this.DYNAMIC_SEARCH_FIMA || !this.FIMA_INCREASE) continue;
                this.saveToItemSupportQueue((Integer)entry.getValue());
                continue;
            }
            mapCurrentItemsLocationList.remove(entry.getKey());
        }
        return frequentItems;
    }

    private void scanDatabaseAgainToDetermineIndexDB(String input, Set<Integer> frequentItemsName) throws IOException {
        Object[] lineSplited;
        String line;
        int currentTID;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        HashMap mapItemLocationList = new HashMap();
        int index = 0;
        if (this.selfIncrement) {
            currentTID = 0;
            while ((line = reader.readLine()) != null) {
                ++currentTID;
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                lineSplited = line.split(" ");
                Arrays.sort(lineSplited);
                for (Object itemString : lineSplited) {
                    Integer item = Integer.parseInt((String)itemString);
                    if (!frequentItemsName.contains(item)) continue;
                    ArrayList<Integer> locationList = (ArrayList<Integer>)mapItemLocationList.get(item);
                    if (locationList == null) {
                        locationList = new ArrayList<Integer>();
                        locationList.add(index);
                        mapItemLocationList.put(item, locationList);
                        this.indexDB.add(new int[]{item, currentTID});
                        ++index;
                        continue;
                    }
                    if ((Integer)locationList.get(locationList.size() - 1) == index) continue;
                    locationList.add(index);
                    mapItemLocationList.put(item, locationList);
                    this.indexDB.add(new int[]{item, currentTID});
                    ++index;
                }
            }
        } else {
            currentTID = 1;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                lineSplited = line.split("\\|");
                String[] lineItems = ((String)lineSplited[0]).split(" ");
                currentTID = Integer.parseInt((String)lineSplited[1]);
                for (String itemString : lineItems) {
                    Integer itemName = Integer.parseInt(itemString);
                    if (!frequentItemsName.contains(itemName)) continue;
                    ArrayList<Integer> locationList = (ArrayList<Integer>)mapItemLocationList.get(itemName);
                    if (locationList == null) {
                        locationList = new ArrayList<Integer>();
                        locationList.add(index);
                        mapItemLocationList.put(itemName, locationList);
                        this.indexDB.add(new int[]{itemName, currentTID});
                        ++index;
                        continue;
                    }
                    if ((Integer)locationList.get(locationList.size() - 1) == index) continue;
                    locationList.add(index);
                    mapItemLocationList.put(itemName, locationList);
                    this.indexDB.add(new int[]{itemName, currentTID});
                    ++index;
                }
            }
        }
        for (int i = 0; i < this.frequentItemsets.size(); ++i) {
            int itemName = this.frequentItemsets.get(i).getName()[0];
            this.frequentItemsets.get(i).setLocationList((List)mapItemLocationList.get(itemName));
        }
    }

    private Set<Integer> scanDatabaseToDetermineFrequentItems(String input) throws IOException {
        String[] lineSplited;
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
        if (this.selfIncrement) {
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                for (String itemString : lineSplited = line.split(" ")) {
                    Integer itemName = Integer.parseInt(itemString);
                    Integer itemSupport = (Integer)mapItemCount.get(itemName);
                    if (itemSupport == null) {
                        mapItemCount.put(itemName, 1);
                        continue;
                    }
                    mapItemCount.put(itemName, itemSupport + 1);
                }
            }
        } else {
            while ((line = reader.readLine()) != null) {
                String[] lineItems;
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                lineSplited = line.split("\\|");
                for (String itemString : lineItems = lineSplited[0].split(" ")) {
                    Integer itemName = Integer.parseInt(itemString);
                    Integer itemSupport = (Integer)mapItemCount.get(itemName);
                    if (itemSupport == null) {
                        mapItemCount.put(itemName, 1);
                        continue;
                    }
                    mapItemCount.put(itemName, itemSupport + 1);
                }
            }
        }
        HashSet<Integer> frequentItemsName = new HashSet<Integer>();
        for (Map.Entry entry : mapItemCount.entrySet()) {
            if ((Integer)entry.getValue() < this.minSupport) continue;
            if (this.ONE_ITEM_INCREASE) {
                this.saveToItemSupportQueue((Integer)entry.getValue());
            }
            Itemset item = new Itemset(new int[]{(Integer)entry.getKey()});
            this.frequentItemsets.add(item);
            frequentItemsName.add((Integer)entry.getKey());
        }
        reader.close();
        return frequentItemsName;
    }

    public void writeResultTofile(String path) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(path));
        if (this.kEpisodes.size() > 0) {
            Object[] patterns = this.kEpisodes.toArray();
            Arrays.sort(patterns);
            for (Object patternObj : patterns) {
                Episode pattern = (Episode)patternObj;
                StringBuilder buffer = new StringBuilder();
                buffer.append(pattern.toString());
                writer.write(buffer.toString());
                writer.newLine();
            }
        }
        writer.close();
    }

    public void printStats() {
        System.out.println("=============  TKE - (head episode) - STATS =============");
        System.out.println(" Candidates count : " + this.candidateCount);
        System.out.println(" Top-k episode count : " + this.kEpisodes.size());
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println(" Total time ~ : " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }

    public void setUseDynamicSearch(boolean useDynamicSearch) {
        this.DYNAMIC_SEARCH_FIMA = useDynamicSearch;
        this.DYNAMIC_SEARCH_SERIAL = useDynamicSearch;
    }
}

