/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.huespan;

import ca.pfv.spmf.algorithms.episodes.huespan.ComplexSequence;
import ca.pfv.spmf.algorithms.episodes.huespan.HighUtilityEpisode;
import ca.pfv.spmf.algorithms.episodes.huespan.HighUtilityEpisodes;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoHUESpan {
    private long startTimestamp;
    private long endTimestamp;
    private long candidateCount = 0L;
    private long combinatedEpisodeCount = 0L;
    private long hueCount = 0L;
    private long matrixPruningCount = 0L;
    private long upperBoundPruningCount = 0L;
    private boolean checkMaximumUtility;
    private boolean useTighterUpperBound;
    private boolean useCoocMatrix;
    private boolean pruningPrefix;
    private boolean showMatrix = false;
    private String outputMatrixPath = "HUE_showMatrix.txt";
    private boolean outputSingleEvents;
    private int episodeWithNonMaxUtilityCount = 0;
    private double minUtilityRatio;
    private double minUtilityAbsolute;
    private int maxDuration;
    private long sequenceUtility = 0L;
    private Map<Integer, Map<Integer, Integer>> coocMapAfter = null;
    private Map<Integer, Map<Integer, Integer>> coocMapEquals = null;
    private BufferedWriter writer = null;
    private HighUtilityEpisodes huepisodes = null;
    private ComplexSequence complexSequence;
    private Map<Integer, MoListUtilityList> mapSingleCandidatesWithMoListAndUtilityList;
    private int largestTID;

    public HighUtilityEpisodes runAlgorithm(String inputFile, String outputFile, double minUtilityRatio, int maxDuration, boolean checkMaximumUtility, boolean useTighterUpperBound, boolean outputSingleEvents, boolean useCoocMatrix, boolean pruningPrefix) throws IOException {
        MemoryLogger.getInstance().reset();
        this.minUtilityRatio = minUtilityRatio;
        this.maxDuration = maxDuration;
        this.checkMaximumUtility = checkMaximumUtility;
        this.useTighterUpperBound = useTighterUpperBound;
        this.outputSingleEvents = outputSingleEvents;
        this.useCoocMatrix = useCoocMatrix;
        this.pruningPrefix = pruningPrefix;
        this.startTimestamp = System.currentTimeMillis();
        if (outputFile == null) {
            this.writer = null;
            this.huepisodes = new HighUtilityEpisodes();
        } else {
            this.huepisodes = null;
            this.writer = new BufferedWriter(new FileWriter(outputFile));
        }
        this.complexSequence = new ComplexSequence();
        this.mapSingleCandidatesWithMoListAndUtilityList = new HashMap<Integer, MoListUtilityList>();
        this.scanDatabaseToFindHighUtilitySingleEpisodes(inputFile);
        this.complexSequence.pruneSingleEventsByUpperBound(this.maxDuration, this.minUtilityAbsolute, this.mapSingleCandidatesWithMoListAndUtilityList, this.useTighterUpperBound);
        if (this.useCoocMatrix) {
            this.buildCoocUtilityMatrix();
        }
        System.out.println("checkMaximumUtility : " + checkMaximumUtility);
        System.out.println(" min utility absolute : " + this.minUtilityAbsolute);
        for (Map.Entry<Integer, MoListUtilityList> entry : this.mapSingleCandidatesWithMoListAndUtilityList.entrySet()) {
            ++this.combinatedEpisodeCount;
            int candidate = entry.getKey();
            ArrayList<int[]> alphaEpisode = new ArrayList<int[]>();
            alphaEpisode.add(new int[]{candidate});
            List<Integer> alphaMOs = entry.getValue().getMoList();
            List<Integer> alphaUtilityList = entry.getValue().getUtilityList();
            ArrayList<Integer> alphaPreviousUtility = new ArrayList<Integer>();
            for (int i = 0; i < alphaMOs.size(); ++i) {
                alphaPreviousUtility.add(0);
            }
            int[] totalUtilityUpperBoundUtilityPairOfMOs = this.calculateUtilityAndUpperBoundOfMOs(candidate, alphaMOs, alphaMOs, alphaPreviousUtility, alphaUtilityList);
            int totalUtility = totalUtilityUpperBoundUtilityPairOfMOs[0];
            int upperBoundUtility = totalUtilityUpperBoundUtilityPairOfMOs[1];
            if ((double)upperBoundUtility >= this.minUtilityAbsolute) {
                if (this.outputSingleEvents && (double)totalUtility >= this.minUtilityAbsolute) {
                    HighUtilityEpisode hue = new HighUtilityEpisode(alphaEpisode, totalUtility);
                    this.save(hue, hue.getSize());
                }
                this.mineHUE(alphaEpisode, alphaMOs, alphaMOs, alphaPreviousUtility, alphaUtilityList);
                MemoryLogger.getInstance().checkMemory();
                continue;
            }
            ++this.upperBoundPruningCount;
        }
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().checkMemory();
        return this.huepisodes;
    }

    private void scanDatabaseToFindHighUtilitySingleEpisodes(String inputFile) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(inputFile));
        int lineNumber = 0;
        while ((line = reader.readLine()) != null) {
            ++lineNumber;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(":");
            String[] events = lineSplited[0].split(" ");
            int totalUtility = Integer.parseInt(lineSplited[1]);
            String[] eventsUtility = lineSplited[2].split(" ");
            for (int i = 0; i < events.length; ++i) {
                Integer event = Integer.parseInt(events[i]);
                Integer eventUtility = Integer.parseInt(eventsUtility[i]);
                this.complexSequence.add(lineNumber, event, eventUtility);
                if (!this.mapSingleCandidatesWithMoListAndUtilityList.containsKey(event)) {
                    this.mapSingleCandidatesWithMoListAndUtilityList.put(event, new MoListUtilityList());
                }
                this.mapSingleCandidatesWithMoListAndUtilityList.get(event).add(lineNumber, eventUtility);
            }
            this.sequenceUtility += (long)totalUtility;
            this.complexSequence.setTotalUtility(lineNumber, totalUtility);
        }
        this.largestTID = lineNumber;
        this.complexSequence.setLargestTID(this.largestTID);
        this.minUtilityAbsolute = (double)this.sequenceUtility * this.minUtilityRatio;
    }

    private void buildCoocUtilityMatrix() throws IOException {
        this.coocMapAfter = new HashMap<Integer, Map<Integer, Integer>>();
        this.coocMapEquals = new HashMap<Integer, Map<Integer, Integer>>();
        for (int TID = 1; TID <= this.largestTID; ++TID) {
            List<int[]> pairs = this.complexSequence.getEventSetAndItsUtilityByTID(TID);
            HashSet<Integer> alreadyProcessedEquals = new HashSet<Integer>();
            for (int[] pair : pairs) {
                int itemI = pair[0];
                int utilityEquals = this.complexSequence.getTotalUtilityOfDuration(TID - this.maxDuration + 1, TID + this.maxDuration - 1);
                Iterator iterator = alreadyProcessedEquals.iterator();
                while (iterator.hasNext()) {
                    Integer utility;
                    int itemJ = (Integer)iterator.next();
                    Map<Integer, Integer> map = this.coocMapEquals.get(itemJ);
                    if (map == null) {
                        map = new HashMap<Integer, Integer>();
                        this.coocMapEquals.put(itemJ, map);
                    }
                    if ((utility = map.get(itemI)) == null) {
                        map.put(itemI, utilityEquals);
                        continue;
                    }
                    map.put(itemI, utility + utilityEquals);
                }
                alreadyProcessedEquals.add(itemI);
                HashSet<Integer> alreadyProcessedAfter = new HashSet<Integer>();
                for (int TIDAfter = TID + 1; TIDAfter <= TID + this.maxDuration - 1; ++TIDAfter) {
                    List<int[]> pairsAfter = this.complexSequence.getEventSetAndItsUtilityByTID(TIDAfter);
                    for (int[] pairAfter : pairsAfter) {
                        Integer utility;
                        int itemJ = pairAfter[0];
                        if (alreadyProcessedAfter.contains(itemJ)) continue;
                        int utilityAfter = this.complexSequence.getTotalUtilityOfDuration(TIDAfter - this.maxDuration + 1, TID + this.maxDuration - 1);
                        Map<Integer, Integer> map = this.coocMapAfter.get(itemI);
                        if (map == null) {
                            map = new HashMap<Integer, Integer>();
                            this.coocMapAfter.put(itemI, map);
                        }
                        if ((utility = map.get(itemJ)) == null) {
                            map.put(itemJ, utilityAfter);
                        } else {
                            map.put(itemJ, utility + utilityAfter);
                        }
                        alreadyProcessedAfter.add(itemJ);
                    }
                }
            }
        }
        if (this.showMatrix) {
            int awu;
            Map<Integer, Integer> map;
            BufferedWriter out = new BufferedWriter(new FileWriter(this.outputMatrixPath));
            for (int itemI : this.coocMapEquals.keySet()) {
                map = this.coocMapEquals.get(itemI);
                for (int itemJ : map.keySet()) {
                    awu = map.get(itemJ);
                    out.write(itemI + " , " + itemJ + "  #AWU: " + awu);
                    out.newLine();
                }
            }
            for (int itemI : this.coocMapAfter.keySet()) {
                map = this.coocMapAfter.get(itemI);
                for (int itemJ : map.keySet()) {
                    awu = map.get(itemJ);
                    out.write(itemI + " -> " + itemJ + "  #AWU: " + awu);
                    out.newLine();
                }
            }
            out.close();
        }
    }

    private void mineHUE(List<int[]> alphaEpisode, List<Integer> alphaStartPoints, List<Integer> alphaEndPoints, List<Integer> alphaPreviousUtilityList, List<Integer> alphaUtilityList) throws IOException {
        ++this.candidateCount;
        this.mineSimultaneousHUE(alphaEpisode, alphaStartPoints, alphaEndPoints, alphaPreviousUtilityList, alphaUtilityList);
        this.mineSerialHUE(alphaEpisode, alphaStartPoints, alphaEndPoints, alphaPreviousUtilityList, alphaUtilityList);
    }

    private void mineSimultaneousHUE(List<int[]> alphaEpisode, List<Integer> alphaStartPoints, List<Integer> alphaEndPoints, List<Integer> alphaPreviousUtilityList, List<Integer> alphaUtilityList) throws IOException {
        HashMap<Integer, 1> mapBetaWithInfoList = new HashMap<Integer, 1>();
        int[] lastItemset = alphaEpisode.get(alphaEpisode.size() - 1);
        int lastItem = lastItemset[lastItemset.length - 1];
        HashSet<Integer> pruningSet = new HashSet<Integer>();
        for (int i = 0; i < alphaEndPoints.size(); ++i) {
            int startPoint = alphaStartPoints.get(i);
            int endPoint = alphaEndPoints.get(i);
            int alphaPreviousUtility = alphaPreviousUtilityList.get(i);
            int alphaUtility = alphaUtilityList.get(i);
            List<int[]> pairsForIextention = this.complexSequence.getPairsForIextension(endPoint, lastItem);
            block1: for (int j = 0; j < pairsForIextention.size(); ++j) {
                int beta = pairsForIextention.get(j)[0];
                int betaUtility = alphaUtility + pairsForIextention.get(j)[1];
                if (this.useCoocMatrix) {
                    if (pruningSet.contains(beta)) continue;
                    for (int itemI : lastItemset) {
                        Integer utilityEquals;
                        Map<Integer, Integer> mapUtilityItemsEquals = this.coocMapEquals.get(itemI);
                        if (mapUtilityItemsEquals == null || (utilityEquals = mapUtilityItemsEquals.get(beta)) != null && !((double)utilityEquals.intValue() < this.minUtilityAbsolute)) continue;
                        pruningSet.add(beta);
                        continue block1;
                    }
                    if (this.pruningPrefix) {
                        for (int size = 0; size < alphaEpisode.size() - 1; ++size) {
                            int[] itemset2;
                            for (int itemI : itemset2 = alphaEpisode.get(size)) {
                                Integer utilityAfter;
                                Map<Integer, Integer> mapUtilityItemsAfter = this.coocMapAfter.get(itemI);
                                if (mapUtilityItemsAfter == null || (utilityAfter = mapUtilityItemsAfter.get(beta)) != null && !((double)utilityAfter.intValue() < this.minUtilityAbsolute)) continue;
                                pruningSet.add(beta);
                                continue block1;
                            }
                        }
                    }
                }
                if (!mapBetaWithInfoList.containsKey(beta)) {
                    mapBetaWithInfoList.put(beta, new ArrayList<List<Integer>>(){
                        {
                            this.add(new ArrayList());
                            this.add(new ArrayList());
                            this.add(new ArrayList());
                            this.add(new ArrayList());
                        }
                    });
                }
                ((List)((List)mapBetaWithInfoList.get(beta)).get(0)).add(startPoint);
                ((List)((List)mapBetaWithInfoList.get(beta)).get(1)).add(endPoint);
                ((List)((List)mapBetaWithInfoList.get(beta)).get(2)).add(alphaPreviousUtility);
                ((List)((List)mapBetaWithInfoList.get(beta)).get(3)).add(betaUtility);
            }
        }
        this.matrixPruningCount += (long)pruningSet.size();
        this.combinatedEpisodeCount += (long)pruningSet.size();
        Iterator iterator = mapBetaWithInfoList.keySet().iterator();
        while (iterator.hasNext()) {
            int beta = (Integer)iterator.next();
            ++this.combinatedEpisodeCount;
            List betaStartPoints = (List)((List)mapBetaWithInfoList.get(beta)).get(0);
            List betaEndPoints = (List)((List)mapBetaWithInfoList.get(beta)).get(1);
            List betaPreviousUtilityList = (List)((List)mapBetaWithInfoList.get(beta)).get(2);
            List betaUtilityList = (List)((List)mapBetaWithInfoList.get(beta)).get(3);
            int[] totalUtilityUpperBoundUtilityPairOfMOs = this.calculateUtilityAndUpperBoundOfMOs(beta, betaStartPoints, betaEndPoints, betaPreviousUtilityList, betaUtilityList);
            int totalUtility = totalUtilityUpperBoundUtilityPairOfMOs[0];
            int upperBoundUtility = totalUtilityUpperBoundUtilityPairOfMOs[1];
            if ((double)upperBoundUtility >= this.minUtilityAbsolute) {
                int[] newLastItemset = new int[lastItemset.length + 1];
                System.arraycopy(lastItemset, 0, newLastItemset, 0, lastItemset.length);
                newLastItemset[lastItemset.length] = beta;
                ArrayList<int[]> betaEpisode = new ArrayList<int[]>(alphaEpisode.subList(0, alphaEpisode.size() - 1));
                betaEpisode.add(newLastItemset);
                if ((double)totalUtility >= this.minUtilityAbsolute) {
                    HighUtilityEpisode hue = new HighUtilityEpisode(betaEpisode, totalUtility);
                    this.save(hue, hue.getSize());
                }
                this.mineHUE(betaEpisode, betaStartPoints, betaEndPoints, betaPreviousUtilityList, betaUtilityList);
                continue;
            }
            ++this.upperBoundPruningCount;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void mineSerialHUE(List<int[]> alphaEpisode, List<Integer> alphaStartPoints, List<Integer> alphaEndPoints, List<Integer> alphaPreviousUtilityList, List<Integer> alphaUtilityList) throws IOException {
        HashMap<Integer, 2> mapBetaWithInfoList = new HashMap<Integer, 2>();
        int[] lastItemset = alphaEpisode.get(alphaEpisode.size() - 1);
        HashSet<Integer> pruningSet = new HashSet<Integer>();
        int previousStartPoint = -1;
        for (int i = 0; i < alphaEndPoints.size(); ++i) {
            int extentionBound;
            int j;
            int startPoint = alphaStartPoints.get(i);
            if (startPoint == previousStartPoint) continue;
            previousStartPoint = startPoint;
            int endPoint = alphaEndPoints.get(i);
            int alphaUtility = alphaUtilityList.get(i);
            for (j = i + 1; j < alphaEndPoints.size() && alphaStartPoints.get(j) == startPoint; ++j) {
            }
            int endPointOfnextMO = this.largestTID;
            if (j < alphaEndPoints.size()) {
                endPointOfnextMO = alphaEndPoints.get(j);
            }
            int n = extentionBound = endPointOfnextMO < startPoint + this.maxDuration - 1 ? endPointOfnextMO : startPoint + this.maxDuration - 1;
            if (!this.useTighterUpperBound && !this.useCoocMatrix) {
                extentionBound = startPoint + this.maxDuration - 1;
            }
            int maximalAlphaUtility = alphaUtility;
            for (int TID = endPoint + 1; TID <= extentionBound; ++TID) {
                block3: for (int[] pair : this.complexSequence.getEventSetAndItsUtilityByTID(TID)) {
                    int beta = pair[0];
                    if (this.checkMaximumUtility && alphaEpisode.size() >= 2) {
                        maximalAlphaUtility = this.complexSequence.getMaximalUtility(alphaEpisode, startPoint, TID - 1);
                    }
                    int betaUtility = maximalAlphaUtility + pair[1];
                    if (this.useCoocMatrix) {
                        if (pruningSet.contains(beta)) continue;
                        for (int itemI : lastItemset) {
                            Integer utilityAfter;
                            Map<Integer, Integer> mapUtilityItemsAfter = this.coocMapAfter.get(itemI);
                            if (mapUtilityItemsAfter == null || (utilityAfter = mapUtilityItemsAfter.get(beta)) != null && !((double)utilityAfter.intValue() < this.minUtilityAbsolute)) continue;
                            pruningSet.add(beta);
                            continue block3;
                        }
                        if (this.pruningPrefix) {
                            for (int size = 0; size < alphaEpisode.size() - 1; ++size) {
                                int[] itemset2;
                                for (int itemI : itemset2 = alphaEpisode.get(size)) {
                                    Integer utilityAfter;
                                    Map<Integer, Integer> mapUtilityItemsAfter = this.coocMapAfter.get(itemI);
                                    if (mapUtilityItemsAfter == null || (utilityAfter = mapUtilityItemsAfter.get(beta)) != null && !((double)utilityAfter.intValue() < this.minUtilityAbsolute)) continue;
                                    pruningSet.add(beta);
                                    continue block3;
                                }
                            }
                        }
                    }
                    if (!mapBetaWithInfoList.containsKey(beta)) {
                        if (maximalAlphaUtility > alphaUtility) {
                            ++this.episodeWithNonMaxUtilityCount;
                        }
                        mapBetaWithInfoList.put(beta, new ArrayList<List<Integer>>(){
                            {
                                this.add(new ArrayList());
                                this.add(new ArrayList());
                                this.add(new ArrayList());
                                this.add(new ArrayList());
                            }
                        });
                    }
                    ((List)((List)mapBetaWithInfoList.get(beta)).get(0)).add(startPoint);
                    ((List)((List)mapBetaWithInfoList.get(beta)).get(1)).add(TID);
                    ((List)((List)mapBetaWithInfoList.get(beta)).get(2)).add(alphaUtility);
                    ((List)((List)mapBetaWithInfoList.get(beta)).get(3)).add(betaUtility);
                }
            }
        }
        this.matrixPruningCount += (long)pruningSet.size();
        this.combinatedEpisodeCount += (long)pruningSet.size();
        Iterator iterator = mapBetaWithInfoList.keySet().iterator();
        while (iterator.hasNext()) {
            int beta = (Integer)iterator.next();
            ++this.combinatedEpisodeCount;
            List betaStartPoints = (List)((List)mapBetaWithInfoList.get(beta)).get(0);
            List betaEndPoints = (List)((List)mapBetaWithInfoList.get(beta)).get(1);
            List betaPreviousUtilityList = (List)((List)mapBetaWithInfoList.get(beta)).get(2);
            List betaUtilityList = (List)((List)mapBetaWithInfoList.get(beta)).get(3);
            int[] totalUtilityUpperBoundUtilityPairOfMOs = this.calculateUtilityAndUpperBoundOfMOs(beta, betaStartPoints, betaEndPoints, betaPreviousUtilityList, betaUtilityList);
            int totalUtility = totalUtilityUpperBoundUtilityPairOfMOs[0];
            int upperBoundUtility = totalUtilityUpperBoundUtilityPairOfMOs[1];
            if ((double)upperBoundUtility >= this.minUtilityAbsolute) {
                ArrayList<int[]> betaEpisode = new ArrayList<int[]>(alphaEpisode.subList(0, alphaEpisode.size()));
                betaEpisode.add(new int[]{beta});
                if ((double)totalUtility >= this.minUtilityAbsolute) {
                    HighUtilityEpisode hue = new HighUtilityEpisode(betaEpisode, totalUtility);
                    this.save(hue, hue.getSize());
                }
                this.mineHUE(betaEpisode, betaStartPoints, betaEndPoints, betaPreviousUtilityList, betaUtilityList);
                continue;
            }
            ++this.upperBoundPruningCount;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private int[] calculateUtilityAndUpperBoundOfMOs(int beta, List<Integer> betaStartPoints, List<Integer> betaEndPoints, List<Integer> betaPreviousUtilityList, List<Integer> betaUtilityList) {
        if (!this.useTighterUpperBound && !this.useCoocMatrix) {
            return this.repaiMOSet(betaStartPoints, betaEndPoints, betaPreviousUtilityList, betaUtilityList);
        }
        int totalUtility = 0;
        int upperBound = 0;
        int previousStartPoint = -1;
        for (int pos = 0; pos < betaStartPoints.size(); ++pos) {
            int startPoint = betaStartPoints.get(pos);
            if (startPoint == previousStartPoint) continue;
            previousStartPoint = startPoint;
            totalUtility += betaUtilityList.get(pos).intValue();
            int endPoint = betaEndPoints.get(pos);
            if (this.useTighterUpperBound) {
                upperBound += betaUtilityList.get(pos) + this.complexSequence.getIrutil(endPoint, beta) + this.complexSequence.getTotalUtilityOfDuration(endPoint + 1, startPoint + this.maxDuration - 1);
                continue;
            }
            upperBound += betaPreviousUtilityList.get(pos) + this.complexSequence.getTotalUtilityOfDuration(endPoint, startPoint + this.maxDuration - 1);
        }
        return new int[]{totalUtility, upperBound};
    }

    public int[] repaiMOSet(List<Integer> betaStartPoints, List<Integer> betaEndPoints, List<Integer> betaPreviousUtilityList, List<Integer> betaUtilityList) {
        HashMap<Integer, Integer> mapStartEnd = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> mapEndStart = new HashMap<Integer, Integer>();
        for (int pos = 0; pos < betaStartPoints.size(); ++pos) {
            int startPoint = betaStartPoints.get(pos);
            int endPoint = betaEndPoints.get(pos);
            if (mapStartEnd.containsKey(startPoint)) {
                int existEndPoint = (Integer)mapStartEnd.get(startPoint);
                if (endPoint >= existEndPoint) continue;
                mapStartEnd.put(startPoint, endPoint);
                mapEndStart.remove(existEndPoint);
                mapEndStart.put(endPoint, startPoint);
                continue;
            }
            mapStartEnd.put(startPoint, endPoint);
            if (mapEndStart.containsKey(endPoint)) {
                int existStartPoint = (Integer)mapEndStart.get(endPoint);
                if (startPoint <= existStartPoint) continue;
                mapEndStart.put(endPoint, startPoint);
                mapStartEnd.remove(existStartPoint);
                mapStartEnd.put(startPoint, endPoint);
                continue;
            }
            mapEndStart.put(endPoint, startPoint);
        }
        int totalUtility = 0;
        int upperBound = 0;
        for (int pos = 0; pos < betaStartPoints.size(); ++pos) {
            int startPoint = betaStartPoints.get(pos);
            int endPoint = betaEndPoints.get(pos);
            if (!mapStartEnd.containsKey(startPoint) || (Integer)mapStartEnd.get(startPoint) != endPoint) continue;
            totalUtility += betaUtilityList.get(pos).intValue();
            upperBound += betaPreviousUtilityList.get(pos) + this.complexSequence.getTotalUtilityOfDuration(endPoint, startPoint + this.maxDuration - 1);
        }
        return new int[]{totalUtility, upperBound};
    }

    public void save(HighUtilityEpisode hue, int k) throws IOException {
        ++this.hueCount;
        if (this.writer != null) {
            this.writer.write(hue.toString());
            this.writer.newLine();
        } else {
            this.huepisodes.addHighUtilityEpisode(hue, k);
        }
    }

    public void printStats() {
        System.out.println("=============  HUE_Span V_1.0  - STATS ===============");
        long temps = this.endTimestamp - this.startTimestamp;
        System.out.println(" The minimum utility absolue: " + this.minUtilityAbsolute);
        System.out.print(" Max memory usage: " + MemoryLogger.getInstance().getMaxMemory() + " mb \n");
        System.out.println(" Episodes counts : " + this.hueCount);
        System.out.println(" Candidate counts : " + this.candidateCount);
        System.out.println(" Combinated episode counts : " + this.combinatedEpisodeCount);
        System.out.println(" matrix pruning counts : " + this.matrixPruningCount);
        System.out.println(" upper Bound pruning counts: " + this.upperBoundPruningCount);
        System.out.println(" non maximal combinated episode counts atleast: " + this.episodeWithNonMaxUtilityCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println("===================================================");
    }

    public class MoListUtilityList {
        List<Integer> moList;
        List<Integer> utilityList;

        public MoListUtilityList() {
            this.moList = new ArrayList<Integer>();
            this.utilityList = new ArrayList<Integer>();
        }

        public MoListUtilityList(List<Integer> moList, List<Integer> utilityList) {
            this.moList = moList;
            this.utilityList = utilityList;
        }

        public void add(int mo, int utility) {
            this.moList.add(mo);
            this.utilityList.add(utility);
        }

        public List<Integer> getMoList() {
            return this.moList;
        }

        public List<Integer> getUtilityList() {
            return this.utilityList;
        }
    }
}

