/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.huespan;

import ca.pfv.spmf.algorithms.episodes.huespan.AlgoHUESpan;
import ca.pfv.spmf.algorithms.episodes.huespan.FiniteStateMachine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ComplexSequence {
    private Map<Integer, EventsEventsUtilityTotalUtility> mapItemEET = new HashMap<Integer, EventsEventsUtilityTotalUtility>();
    private int largestTID = 0;

    public List<int[]> getPairsForIextension(int timePoint, int lastItem) {
        List<int[]> returnPairsList = new ArrayList<int[]>();
        List<int[]> pairs = this.mapItemEET.get(timePoint).getPairs();
        for (int i = 1; i < pairs.size(); ++i) {
            if (pairs.get(i - 1)[0] != lastItem) continue;
            returnPairsList = pairs.subList(i, pairs.size());
            break;
        }
        return returnPairsList;
    }

    public int getIrutil(int timePoint, int item) {
        int iutil = 0;
        List<int[]> pairs = this.mapItemEET.get(timePoint).getPairs();
        for (int i = pairs.size() - 1; i > 0 && pairs.get(i)[0] != item; --i) {
            iutil += pairs.get(i)[1];
        }
        return iutil;
    }

    public void pruneSingleEventsByUpperBound(int maxDuration, double minUtilityAbsolute, Map<Integer, AlgoHUESpan.MoListUtilityList> mapSingleCandidatesWithMOsUtilityPair, boolean useTigherUpperBound) {
        int actUtility;
        final HashMap<Integer, Integer> mapEventWithActUtility = new HashMap<Integer, Integer>();
        for (int TID = 1; TID <= this.largestTID; ++TID) {
            EventsEventsUtilityTotalUtility eet = this.mapItemEET.get(TID);
            if (eet == null) continue;
            actUtility = this.getTotalUtilityOfDuration(TID - maxDuration + 1, TID + maxDuration - 1);
            for (int[] pair : eet.getPairs()) {
                mapEventWithActUtility.put(pair[0], mapEventWithActUtility.getOrDefault(pair[0], 0) + actUtility);
            }
        }
        Iterator TID = mapEventWithActUtility.keySet().iterator();
        while (TID.hasNext()) {
            int item = (Integer)TID.next();
            actUtility = (Integer)mapEventWithActUtility.get(item);
            if (!((double)actUtility < minUtilityAbsolute)) continue;
            mapSingleCandidatesWithMOsUtilityPair.remove(item);
        }
        for (int TID2 = 1; TID2 <= this.largestTID; ++TID2) {
            EventsEventsUtilityTotalUtility eet = this.mapItemEET.get(TID2);
            if (eet == null) continue;
            List<int[]> pairs = eet.getPairs();
            int removedUtilitySum = 0;
            for (int i = pairs.size() - 1; i >= 0; --i) {
                int event = pairs.get(i)[0];
                if (mapSingleCandidatesWithMOsUtilityPair.containsKey(event)) continue;
                removedUtilitySum += pairs.get(i)[1];
                pairs.remove(i);
            }
            if (pairs.size() > 0) {
                if (useTigherUpperBound) {
                    Collections.sort(pairs, new Comparator<int[]>(){

                        @Override
                        public int compare(int[] o1, int[] o2) {
                            return (Integer)mapEventWithActUtility.get(o1[0]) - (Integer)mapEventWithActUtility.get(o2[0]);
                        }
                    });
                } else {
                    Collections.sort(pairs, new Comparator<int[]>(){

                        @Override
                        public int compare(int[] o1, int[] o2) {
                            return o1[0] - o2[0];
                        }
                    });
                }
                eet.setPairs(pairs);
                eet.setTotalUtility(eet.getTotalUtility() - removedUtilitySum);
                continue;
            }
            this.mapItemEET.remove(TID2);
        }
        mapEventWithActUtility.clear();
    }

    public int getTotalUtilityOfDuration(int start, int end) {
        if (start > this.largestTID) {
            return 0;
        }
        if (end > this.largestTID) {
            end = this.largestTID;
        }
        int totalUtility = 0;
        for (int TID = start; TID <= end; ++TID) {
            if (!this.mapItemEET.containsKey(TID)) continue;
            totalUtility += this.mapItemEET.get(TID).getTotalUtility();
        }
        return totalUtility;
    }

    public int getMaximalUtility(List<int[]> episode, int start, int end) {
        int maximalUtility = 0;
        ArrayList<FiniteStateMachine> fsaList = new ArrayList<FiniteStateMachine>();
        int utilityOfFirstEventSet = this.getEventsUtilityByTID(episode.get(0), start);
        fsaList.add(new FiniteStateMachine(episode, utilityOfFirstEventSet));
        for (int TID = start + 1; TID <= end; ++TID) {
            if (!this.mapItemEET.containsKey(TID)) continue;
            List<int[]> pairs = this.mapItemEET.get(TID).getPairs();
            for (int j = fsaList.size() - 1; j >= 0; --j) {
                if (!((FiniteStateMachine)fsaList.get(j)).scan(pairs)) continue;
                ((FiniteStateMachine)fsaList.get(j)).transit();
                if (j == fsaList.size() - 1) {
                    fsaList.add(new FiniteStateMachine(episode, utilityOfFirstEventSet));
                }
                if (((FiniteStateMachine)fsaList.get(j)).isEnd()) {
                    maximalUtility = Math.max(maximalUtility, ((FiniteStateMachine)fsaList.get(j)).getUtility());
                    fsaList.remove(j);
                }
                if (j < 1 || !((FiniteStateMachine)fsaList.get(j)).isSame((FiniteStateMachine)fsaList.get(j - 1)) || ((FiniteStateMachine)fsaList.get(j - 1)).scan(pairs)) continue;
                if (((FiniteStateMachine)fsaList.get(j)).getUtility() - ((FiniteStateMachine)fsaList.get(j - 1)).getUtility() >= 0) {
                    fsaList.remove(j - 1);
                    --j;
                    continue;
                }
                fsaList.remove(j);
            }
        }
        return maximalUtility;
    }

    public int getEventsUtilityByTID(int[] eventset, int tid) {
        int utility = 0;
        int index = 0;
        List<int[]> pairs = this.mapItemEET.get(tid).getPairs();
        for (int j = 0; j < pairs.size() && index != eventset.length; ++j) {
            int item = pairs.get(j)[0];
            if (item != eventset[index]) continue;
            ++index;
            utility += pairs.get(j)[1];
        }
        return index == eventset.length ? utility : 0;
    }

    public void add(int tid, int event, int utility) {
        EventsEventsUtilityTotalUtility eet = this.mapItemEET.get(tid);
        if (eet == null) {
            eet = new EventsEventsUtilityTotalUtility();
            this.mapItemEET.put(tid, eet);
        }
        eet.add(event, utility);
    }

    public List<int[]> getEventSetAndItsUtilityByTID(int tid) {
        return this.mapItemEET.containsKey(tid) ? this.mapItemEET.get(tid).getPairs() : new ArrayList<int[]>();
    }

    public void setTotalUtility(int tid, int totalUtility) {
        this.mapItemEET.get(tid).setTotalUtility(totalUtility);
    }

    public void setLargestTID(int tid) {
        this.largestTID = tid;
    }

    public class EventsEventsUtilityTotalUtility {
        List<int[]> pairs;
        int totalUtility;

        public EventsEventsUtilityTotalUtility() {
            this.pairs = new ArrayList<int[]>();
            this.totalUtility = 0;
        }

        public EventsEventsUtilityTotalUtility(List<int[]> pairs, int totalUtility) {
            this.pairs = pairs;
            this.totalUtility = totalUtility;
        }

        public void add(int event, int utility) {
            this.pairs.add(new int[]{event, utility});
        }

        public void setTotalUtility(int totalUtility) {
            this.totalUtility = totalUtility;
        }

        public int getTotalUtility() {
            return this.totalUtility;
        }

        public List<int[]> getPairs() {
            return this.pairs;
        }

        public void setPairs(List<int[]> pairs) {
            this.pairs = pairs;
        }

        public int getIremainingUtilityByevent(int event) {
            int[] pair;
            int iRemainingUtility = 0;
            for (int i = this.pairs.size() - 1; i > 0 && (pair = this.pairs.get(i))[0] > event; --i) {
                iRemainingUtility += pair[1];
            }
            return iRemainingUtility;
        }
    }
}

