/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.minepiplus;

import ca.pfv.spmf.algorithms.episodes.minepiplus.Episode;
import ca.pfv.spmf.algorithms.episodes.minepiplus.FrequentEpisodes;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoMINEPIPlus {
    private long startTimestamp;
    private long endTimestamp;
    private int candidateCount = 0;
    private boolean selfIncrement;
    protected FrequentEpisodes freEpisodes = null;
    private List<Episode> f1;
    private List<List<int[]>> f1BoundList;
    private int minSupport;
    private int maxWindow;

    public FrequentEpisodes runAlgorithm(String input, String output, int minSupport, int maxWindow, boolean selfIncrement) throws IOException {
        MemoryLogger.getInstance().reset();
        this.minSupport = minSupport;
        this.maxWindow = maxWindow;
        this.selfIncrement = selfIncrement;
        this.startTimestamp = System.currentTimeMillis();
        this.freEpisodes = new FrequentEpisodes();
        this.scanDatabaseToDetermineFrequentSingleEpisode(input);
        for (int i = 0; i < this.f1.size(); ++i) {
            this.serialJoins(this.f1.get(i), this.f1BoundList.get(i), this.f1.get(i).getLastItem(), 1);
        }
        this.endTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().checkMemory();
        if (output != null) {
            this.freEpisodes.saveToFile(output);
        }
        return this.freEpisodes;
    }

    public void serialJoins(Episode alpha, List<int[]> alphaBoundlist, int lastItem, int levelNum) {
        for (int j = 0; j < this.f1.size(); ++j) {
            Episode beta;
            List<int[]> tempBoundlist;
            int support;
            Episode fj = this.f1.get(j);
            if (fj.getLastItem() > lastItem && (support = this.getEntityCount(tempBoundlist = this.equalJoin(alphaBoundlist, this.f1BoundList.get(j)))) >= this.minSupport) {
                beta = alpha.iExtension(fj.getLastItem(), support);
                this.freEpisodes.addFrequentEpisode(beta, levelNum);
                this.serialJoins(beta, tempBoundlist, fj.getLastItem(), levelNum);
            }
            if ((support = this.getEntityCount(tempBoundlist = this.temporalJoin(alphaBoundlist, this.f1BoundList.get(j)))) < this.minSupport) continue;
            beta = alpha.sExtension(fj.getLastItem(), support);
            this.freEpisodes.addFrequentEpisode(beta, levelNum + 1);
            this.serialJoins(beta, tempBoundlist, fj.getLastItem(), levelNum + 1);
        }
    }

    private int getEntityCount(List<int[]> tempBoundlist) {
        if (tempBoundlist.size() <= 0) {
            return 0;
        }
        int support = 1;
        int lastStarTime = tempBoundlist.get(0)[0];
        for (int i = 0; i < tempBoundlist.size(); ++i) {
            if (lastStarTime == tempBoundlist.get(i)[0]) continue;
            ++support;
            lastStarTime = tempBoundlist.get(i)[0];
        }
        return support;
    }

    private List<int[]> temporalJoin(List<int[]> alphaBoundlist, List<int[]> fjBoundlist) {
        ++this.candidateCount;
        ArrayList<int[]> tempBoundlist = new ArrayList<int[]>();
        block0: for (int i = 0; i < alphaBoundlist.size(); ++i) {
            for (int j = 0; j < fjBoundlist.size(); ++j) {
                if (fjBoundlist.get(j)[1] <= alphaBoundlist.get(i)[1]) continue;
                if (fjBoundlist.get(j)[1] - alphaBoundlist.get(i)[0] >= this.maxWindow) continue block0;
                int[] boundlist = new int[]{alphaBoundlist.get(i)[0], fjBoundlist.get(j)[1]};
                tempBoundlist.add(boundlist);
            }
        }
        return tempBoundlist;
    }

    private List<int[]> equalJoin(List<int[]> alphaBoundlist, List<int[]> fjBoundlist) {
        ++this.candidateCount;
        ArrayList<int[]> tempBoundlist = new ArrayList<int[]>();
        block0: for (int i = 0; i < alphaBoundlist.size(); ++i) {
            for (int j = 0; j < fjBoundlist.size() && alphaBoundlist.get(i)[1] >= fjBoundlist.get(j)[1]; ++j) {
                if (alphaBoundlist.get(i)[1] != fjBoundlist.get(j)[1]) continue;
                tempBoundlist.add(alphaBoundlist.get(i));
                continue block0;
            }
        }
        return tempBoundlist;
    }

    private void scanDatabaseToDetermineFrequentSingleEpisode(String input) throws IOException {
        String[] lineSplited;
        String line;
        int currentTID;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        HashMap<Integer, ArrayList<int[]>> mapSingleEventCount = new HashMap<Integer, ArrayList<int[]>>();
        if (this.selfIncrement) {
            currentTID = 0;
            while ((line = reader.readLine()) != null) {
                ++currentTID;
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                for (String itemString : lineSplited = line.split(" ")) {
                    Integer itemName = Integer.parseInt(itemString);
                    ArrayList<int[]> bouldList = (ArrayList<int[]>)mapSingleEventCount.get(itemName);
                    if (bouldList == null) {
                        bouldList = new ArrayList<int[]>();
                        bouldList.add(new int[]{currentTID, currentTID});
                        mapSingleEventCount.put(itemName, bouldList);
                        ++this.candidateCount;
                        continue;
                    }
                    bouldList.add(new int[]{currentTID, currentTID});
                    mapSingleEventCount.put(itemName, bouldList);
                }
            }
        } else {
            currentTID = 1;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                lineSplited = line.split("\\|");
                String[] lineItems = lineSplited[0].split(" ");
                currentTID = Integer.parseInt(lineSplited[1]);
                for (String itemString : lineItems) {
                    Integer itemName = Integer.parseInt(itemString);
                    ArrayList<int[]> bouldList = (ArrayList<int[]>)mapSingleEventCount.get(itemName);
                    if (bouldList == null) {
                        bouldList = new ArrayList<int[]>();
                        bouldList.add(new int[]{currentTID, currentTID});
                        mapSingleEventCount.put(itemName, bouldList);
                        ++this.candidateCount;
                        continue;
                    }
                    bouldList.add(new int[]{currentTID, currentTID});
                    mapSingleEventCount.put(itemName, bouldList);
                }
            }
        }
        this.freEpisodes = new FrequentEpisodes();
        this.f1 = new ArrayList<Episode>();
        this.f1BoundList = new ArrayList<List<int[]>>();
        for (Map.Entry entry : mapSingleEventCount.entrySet()) {
            List bouldList = (List)entry.getValue();
            if (bouldList.size() < this.minSupport) continue;
            final int[] symbol = new int[]{(Integer)entry.getKey()};
            ArrayList<int[]> event = new ArrayList<int[]>(){
                {
                    this.add(symbol);
                }
            };
            Episode episode = new Episode((List<int[]>)event, bouldList.size());
            this.freEpisodes.addFrequentEpisode(episode, 1);
            this.f1.add(episode);
            this.f1BoundList.add(bouldList);
        }
    }

    public void printStats() {
        System.out.println("=============  MINEPI+_S (head episode) - STATS =============");
        System.out.println(" Candidates count : " + this.candidateCount);
        System.out.println(" The algorithm stopped at size : " + this.freEpisodes.getTotalLevelNum());
        System.out.println(" Frequent episodes count : " + this.freEpisodes.getFrequentEpisodesCount());
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println(" Total time ~ : " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }
}

